/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.idempotentexecutor;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.datatransferproject.spi.transfer.idempotentexecutor.CachingExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.ImportFunction;
import org.datatransferproject.spi.transfer.idempotentexecutor.ItemImportResult;
import org.datatransferproject.types.common.ImportableItem;

public interface IdempotentImportExecutor
extends CachingExecutor {
    @Nullable
    default public <T extends ImportableItem, R extends Serializable> R importAndSwallowIOExceptions(T item, ImportFunction<T, R> function) throws Exception {
        return (R)this.executeAndSwallowIOExceptions(item.getIdempotentId(), item.getName(), () -> {
            ItemImportResult r = function.apply(item);
            if (r.getStatus() == ItemImportResult.Status.SUCCESS) {
                return (Serializable)r.getData();
            }
            throw r.getException();
        });
    }

    default public <T extends ImportableItem, R extends Serializable> List<R> importBatchAndSwallowIOExceptions(List<T> items, ImportFunction<List<T>, List<R>> function) {
        throw new UnsupportedOperationException();
    }
}

