/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.idempotentexecutor;

import com.google.common.base.Preconditions;
import java.io.Serializable;

public class ItemImportResult<T> {
    private final T data;
    private final Long bytes;
    private final Status status;
    private final Exception exception;

    private ItemImportResult(T data, Long bytes, Status status, Exception exception) {
        Preconditions.checkArgument((bytes == null || bytes >= 0L ? 1 : 0) != 0);
        this.data = data;
        this.bytes = bytes;
        this.status = status;
        this.exception = exception;
    }

    public static <T extends Serializable> ItemImportResult<T> success(T data, Long sizeInBytes) {
        Preconditions.checkNotNull(data);
        return new ItemImportResult<T>(data, sizeInBytes, Status.SUCCESS, null);
    }

    public static <T extends Serializable> ItemImportResult<T> success(T data) {
        return ItemImportResult.success(data, null);
    }

    public static <T extends Serializable> ItemImportResult<T> error(Exception exception, Long sizeInBytes) {
        Preconditions.checkNotNull((Object)exception);
        return new ItemImportResult<Object>(null, sizeInBytes, Status.ERROR, exception);
    }

    public T getData() {
        Preconditions.checkState((this.status == Status.SUCCESS ? 1 : 0) != 0, (Object)"Failed import can't contain data");
        return this.data;
    }

    public boolean hasBytes() {
        return this.bytes != null;
    }

    public long getBytes() {
        Preconditions.checkState((boolean)this.hasBytes(), (Object)"Result does not contain size info");
        return this.bytes;
    }

    public Status getStatus() {
        return this.status;
    }

    public Exception getException() {
        Preconditions.checkState((this.status == Status.ERROR ? 1 : 0) != 0, (Object)"Successful import can't contain throwable");
        return this.exception;
    }

    public static enum Status {
        SUCCESS,
        ERROR;

    }
}

