/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.provider;

import org.datatransferproject.spi.transfer.provider.SignalRequest;
import org.datatransferproject.spi.transfer.types.signals.JobLifeCycle;

final class AutoValue_SignalRequest
extends SignalRequest {
    private final String jobId;
    private final String dataType;
    private final JobLifeCycle jobStatus;
    private final String exportingService;
    private final String importingService;

    private AutoValue_SignalRequest(String jobId, String dataType, JobLifeCycle jobStatus, String exportingService, String importingService) {
        this.jobId = jobId;
        this.dataType = dataType;
        this.jobStatus = jobStatus;
        this.exportingService = exportingService;
        this.importingService = importingService;
    }

    @Override
    public String jobId() {
        return this.jobId;
    }

    @Override
    public String dataType() {
        return this.dataType;
    }

    @Override
    public JobLifeCycle jobStatus() {
        return this.jobStatus;
    }

    @Override
    public String exportingService() {
        return this.exportingService;
    }

    @Override
    public String importingService() {
        return this.importingService;
    }

    public String toString() {
        return "SignalRequest{jobId=" + this.jobId + ", dataType=" + this.dataType + ", jobStatus=" + this.jobStatus + ", exportingService=" + this.exportingService + ", importingService=" + this.importingService + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SignalRequest) {
            SignalRequest that = (SignalRequest)o;
            return this.jobId.equals(that.jobId()) && this.dataType.equals(that.dataType()) && this.jobStatus.equals(that.jobStatus()) && this.exportingService.equals(that.exportingService()) && this.importingService.equals(that.importingService());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.jobId.hashCode();
        h$ *= 1000003;
        h$ ^= this.dataType.hashCode();
        h$ *= 1000003;
        h$ ^= this.jobStatus.hashCode();
        h$ *= 1000003;
        h$ ^= this.exportingService.hashCode();
        h$ *= 1000003;
        return h$ ^= this.importingService.hashCode();
    }

    static final class Builder
    extends SignalRequest.Builder {
        private String jobId;
        private String dataType;
        private JobLifeCycle jobStatus;
        private String exportingService;
        private String importingService;

        Builder() {
        }

        @Override
        public SignalRequest.Builder setJobId(String jobId) {
            if (jobId == null) {
                throw new NullPointerException("Null jobId");
            }
            this.jobId = jobId;
            return this;
        }

        @Override
        public SignalRequest.Builder setDataType(String dataType) {
            if (dataType == null) {
                throw new NullPointerException("Null dataType");
            }
            this.dataType = dataType;
            return this;
        }

        @Override
        public SignalRequest.Builder setJobStatus(JobLifeCycle jobStatus) {
            if (jobStatus == null) {
                throw new NullPointerException("Null jobStatus");
            }
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public SignalRequest.Builder setExportingService(String exportingService) {
            if (exportingService == null) {
                throw new NullPointerException("Null exportingService");
            }
            this.exportingService = exportingService;
            return this;
        }

        @Override
        public SignalRequest.Builder setImportingService(String importingService) {
            if (importingService == null) {
                throw new NullPointerException("Null importingService");
            }
            this.importingService = importingService;
            return this;
        }

        @Override
        public SignalRequest build() {
            if (this.jobId == null || this.dataType == null || this.jobStatus == null || this.exportingService == null || this.importingService == null) {
                StringBuilder missing = new StringBuilder();
                if (this.jobId == null) {
                    missing.append(" jobId");
                }
                if (this.dataType == null) {
                    missing.append(" dataType");
                }
                if (this.jobStatus == null) {
                    missing.append(" jobStatus");
                }
                if (this.exportingService == null) {
                    missing.append(" exportingService");
                }
                if (this.importingService == null) {
                    missing.append(" importingService");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SignalRequest(this.jobId, this.dataType, this.jobStatus, this.exportingService, this.importingService);
        }
    }
}

