/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.provider;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ImportResult {
    public static final ImportResult OK = new ImportResult(ResultType.OK);
    private ResultType type;
    private Optional<Throwable> throwable = Optional.empty();
    private Optional<Map<String, Integer>> counts = Optional.empty();
    private Optional<Long> bytes = Optional.empty();

    public ImportResult(Throwable throwable) {
        this.type = ResultType.ERROR;
        this.throwable = Optional.of(throwable);
    }

    public ImportResult(ResultType type) {
        this.type = type;
    }

    public ImportResult(ResultType type, Optional<Throwable> throwable, Optional<Map<String, Integer>> counts, Optional<Long> bytes) {
        this.type = type;
        this.throwable = throwable;
        this.counts = counts;
        this.bytes = bytes;
    }

    public static ImportResult merge(ImportResult ir1, ImportResult ir2) {
        if (ir1.getType() == ResultType.ERROR) {
            return ir1;
        }
        if (ir2.getType() == ResultType.ERROR) {
            return ir2;
        }
        ImportResult res = new ImportResult(ResultType.OK);
        res.bytes = Stream.of(ir1.getBytes(), ir2.getBytes()).filter(Optional::isPresent).map(Optional::get).reduce(Long::sum);
        res.counts = ImportResult.mergeCounts(ir1, ir2);
        return res;
    }

    private static Optional<Map<String, Integer>> mergeCounts(ImportResult ir1, ImportResult ir2) {
        if (ir1.counts.isPresent() && ir2.counts.isPresent()) {
            HashMap<String, Integer> map = new HashMap<String, Integer>(ir1.counts.get());
            ir2.counts.get().forEach((k, v) -> map.merge((String)k, (Integer)v, Integer::sum));
            return Optional.of(map);
        }
        return ir1.counts.isPresent() ? ir1.counts : ir2.counts;
    }

    public ResultType getType() {
        return this.type;
    }

    public Optional<Throwable> getThrowable() {
        return this.throwable;
    }

    public Optional<Map<String, Integer>> getCounts() {
        return this.counts;
    }

    public Optional<Long> getBytes() {
        return this.bytes;
    }

    public ImportResult copyWithCounts(Map<String, Integer> newCounts) {
        return new ImportResult(this.type, this.throwable, Optional.ofNullable(newCounts), this.bytes);
    }

    public ImportResult copyWithBytes(Long bytes) {
        return new ImportResult(this.type, this.throwable, this.counts, Optional.ofNullable(bytes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportResult)) {
            return false;
        }
        ImportResult that = (ImportResult)o;
        return this.type == that.type && Objects.equals(this.throwable, that.throwable) && Objects.equals(this.counts, that.counts) && Objects.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.throwable, this.counts, this.bytes});
    }

    public static enum ResultType {
        OK,
        ERROR;

    }
}

