/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.provider.converter;

import java.util.UUID;
import java.util.function.Function;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.transfer.auth.AuthData;

public class AnyToAnyImporter<AD extends AuthData, From extends ContainerResource, To extends ContainerResource>
implements Importer<AD, To> {
    private final Importer<AD, From> importer;
    private final Function<To, From> converter;

    public AnyToAnyImporter(Importer<AD, From> importer, Function<To, From> converter) {
        this.importer = importer;
        this.converter = converter;
    }

    @Override
    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, AD authData, To data) throws Exception {
        return this.importer.importItem(jobId, idempotentExecutor, authData, (ContainerResource)this.converter.apply(data));
    }
}

