/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.provider.converter;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.transfer.auth.AuthData;

public class AnyToAnyExporter<AD extends AuthData, From extends ContainerResource, To extends ContainerResource>
implements Exporter<AD, To> {
    private final Exporter<AD, From> exporter;
    private final Function<From, To> containerResourceConverter;
    private final Function<ContainerResource, ContainerResource> exportInformationConverter;

    public AnyToAnyExporter(Exporter<AD, From> exporter, Function<From, To> containerResourceConverter, Function<ContainerResource, ContainerResource> exportInformationConverter) {
        this.exporter = exporter;
        this.containerResourceConverter = containerResourceConverter;
        this.exportInformationConverter = exportInformationConverter;
    }

    public AnyToAnyExporter(Exporter<AD, From> exporter, Function<From, To> containerResourceConverter) {
        this(exporter, containerResourceConverter, Function.identity());
    }

    @Override
    public ExportResult<To> export(UUID jobId, AD authData, Optional<ExportInformation> exportInfo) throws Exception {
        Optional<ExportInformation> infoWithConvertedResource = exportInfo.map(ei -> ei.copyWithResource(this.exportInformationConverter.apply(ei.getContainerResource())));
        ExportResult<From> originalResult = this.exporter.export(jobId, authData, infoWithConvertedResource);
        return originalResult.copyWithExportedData((ContainerResource)this.containerResourceConverter.apply((ContainerResource)originalResult.getExportedData()));
    }
}

