/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import org.datatransferproject.types.common.ImportableItem;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;

@JsonTypeName(value="org.dataportability:TempMediaData")
public class TempMediaData
extends DataModel {
    @JsonProperty(value="jobId")
    private final UUID jobId;
    @JsonProperty(value="tempPhotoAlbums")
    private final Map<String, PhotoAlbum> tempPhotoAlbums;
    @JsonProperty(value="newAlbumIds")
    private final Map<String, String> newAlbumIds;
    @JsonProperty(value="containedPhotoIds")
    private final Collection<String> containedPhotoIds;

    @JsonCreator
    public TempMediaData(@JsonProperty(value="jobId") UUID jobId, @JsonProperty(value="tempPhotoAlbums") Map<String, PhotoAlbum> tempPhotoAlbums, @JsonProperty(value="newAlbumIds") Map<String, String> newAlbumIds, @JsonProperty(value="containedPhotoIds") Collection<String> containedPhotoIds) {
        this.jobId = jobId;
        this.tempPhotoAlbums = tempPhotoAlbums;
        this.newAlbumIds = newAlbumIds;
        this.containedPhotoIds = containedPhotoIds;
    }

    public TempMediaData(@JsonProperty(value="jobId") UUID jobId) {
        this.jobId = jobId;
        this.tempPhotoAlbums = new HashMap<String, PhotoAlbum>();
        this.newAlbumIds = new HashMap<String, String>();
        this.containedPhotoIds = new LinkedHashSet<String>();
    }

    public void addTempAlbumMapping(String key, PhotoAlbum album) {
        this.tempPhotoAlbums.put(key, album);
    }

    public PhotoAlbum lookupTempAlbum(String key) {
        return this.tempPhotoAlbums.getOrDefault(key, null);
    }

    public void addAlbumId(String oldAlbumId, String newAlbumId) {
        this.newAlbumIds.put(oldAlbumId, newAlbumId);
    }

    public String lookupNewAlbumId(String oldAlbumId) {
        return this.newAlbumIds.getOrDefault(oldAlbumId, "");
    }

    public void removeTempPhotoAlbum(String key) {
        if (this.tempPhotoAlbums.containsKey(key)) {
            this.tempPhotoAlbums.remove(key);
        }
    }

    public void addContainedPhotoId(String photoId) {
        this.markContained(photoId);
    }

    public void addAllContainedPhotoIds(Collection<String> photoIds) {
        this.containedPhotoIds.addAll(photoIds);
    }

    public Collection<String> lookupContainedPhotoIds() {
        return this.containedPhotoIds;
    }

    public boolean isContainedPhotoId(String photoId) {
        return this.isContained(photoId);
    }

    private boolean isContained(String idempotentId) {
        return this.containedPhotoIds.contains(idempotentId);
    }

    private void markContained(String idempotentId) {
        this.containedPhotoIds.add(idempotentId);
    }

    public boolean isContained(ImportableItem item) {
        return this.containedPhotoIds.contains(item.getIdempotentId());
    }

    public void markContained(ImportableItem item) {
        this.containedPhotoIds.add(item.getIdempotentId());
    }
}

