/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.types.signals;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.datatransferproject.spi.transfer.types.FailureReasons;
import org.datatransferproject.spi.transfer.types.signals.AutoValue_JobLifeCycle;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class JobLifeCycle {
    public static Builder builder() {
        return new AutoValue_JobLifeCycle.Builder().setState(State.UNKNOWN_STATE);
    }

    @JsonProperty(value="state")
    public abstract State state();

    @Nullable
    @JsonProperty(value="failureReason")
    public abstract FailureReasons failureReason();

    @Nullable
    @JsonProperty(value="endReason")
    public abstract EndReason endReason();

    public static JobLifeCycle JOB_STARTED() {
        return JobLifeCycle.builder().setState(State.STARTED).build();
    }

    public static enum EndReason {
        PAUSED,
        INTERRUPTED,
        SUCCESSFULLY_COMPLETED,
        PARTIALLY_COMPLETED,
        ERRORED;

    }

    public static enum State {
        STARTED,
        IN_PROGRESS,
        ENDED,
        UNKNOWN_STATE;

    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setState(State var1);

        public abstract Builder setFailureReason(FailureReasons var1);

        public abstract Builder setEndReason(EndReason var1);

        abstract JobLifeCycle autoBuild();

        public final JobLifeCycle build() {
            JobLifeCycle jobLifeCycle = this.autoBuild();
            if (jobLifeCycle.state().equals((Object)State.ENDED)) {
                Preconditions.checkArgument((jobLifeCycle.endReason() != null ? 1 : 0) != 0, (Object)"End reason required when JobState is ENDED");
            }
            return jobLifeCycle;
        }
    }
}

