/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.provider;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.types.common.models.DataModel;

public class ExportResult<T extends DataModel> {
    public static final ExportResult CONTINUE = new ExportResult(ResultType.CONTINUE);
    public static final ExportResult END = new ExportResult(ResultType.CONTINUE);
    private ResultType type;
    private T exportedData;
    private ContinuationData continuationData;
    private Optional<Throwable> throwable = Optional.empty();

    public ExportResult(ResultType type) {
        this.verifyNonErrorResultType(type);
        this.type = type;
    }

    public ExportResult(ResultType type, T exportedData) {
        this.verifyNonErrorResultType(type);
        this.type = type;
        this.exportedData = exportedData;
    }

    public <R extends DataModel> ExportResult<R> copyWithExportedData(R replacementData) {
        return new ExportResult<R>(this.getType(), replacementData, this.getContinuationData());
    }

    public ExportResult(ResultType type, T exportedData, ContinuationData continuationData) {
        this.verifyNonErrorResultType(type);
        this.type = type;
        this.exportedData = exportedData;
        this.continuationData = continuationData;
    }

    public ExportResult(Throwable throwable) {
        this.type = ResultType.ERROR;
        this.throwable = Optional.of(throwable);
    }

    public ResultType getType() {
        return this.type;
    }

    public T getExportedData() {
        return this.exportedData;
    }

    public ContinuationData getContinuationData() {
        return this.continuationData;
    }

    public Optional<Throwable> getThrowable() {
        return this.throwable;
    }

    private void verifyNonErrorResultType(ResultType type) {
        String mustHaveThrowable = "ExportResult with ResultType = ERROR must hold a throwable";
        Preconditions.checkArgument((!type.equals((Object)ResultType.ERROR) ? 1 : 0) != 0, (Object)mustHaveThrowable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportResult)) {
            return false;
        }
        ExportResult that = (ExportResult)o;
        return this.type == that.type && Objects.equals(this.exportedData, that.exportedData) && Objects.equals((Object)this.continuationData, (Object)that.continuationData) && Objects.equals(this.throwable, that.throwable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.exportedData, this.continuationData, this.throwable});
    }

    public static enum ResultType {
        CONTINUE,
        END,
        ERROR;


        public static ResultType merge(ResultType t1, ResultType t2) {
            if (t1 == ERROR || t2 == ERROR) {
                return ERROR;
            }
            if (t1 == CONTINUE || t2 == CONTINUE) {
                return CONTINUE;
            }
            return END;
        }
    }
}

