/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.copier.stack;

import com.google.inject.Provider;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.spi.transfer.types.CopyException;
import org.datatransferproject.transfer.Annotations;
import org.datatransferproject.transfer.copier.PortabilityAbstractInMemoryDataCopier;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.transfer.auth.AuthData;
import org.datatransferproject.types.transfer.retry.RetryStrategyLibrary;

public class PortabilityStackInMemoryDataCopier
extends PortabilityAbstractInMemoryDataCopier {
    private static final AtomicInteger COPY_ITERATION_COUNTER = new AtomicInteger();
    private Stack<ExportInformation> exportInfoStack = new Stack();

    @Inject
    public PortabilityStackInMemoryDataCopier(Provider<Exporter> exporterProvider, Provider<Importer> importerProvider, Provider<RetryStrategyLibrary> retryStrategyLibraryProvider, Monitor monitor, IdempotentImportExecutor idempotentImportExecutor, @Annotations.RetryingExecutor IdempotentImportExecutor retryingIdempotentImportExecutor, DtpInternalMetricRecorder dtpInternalMetricRecorder, JobStore jobStore) {
        super(exporterProvider, importerProvider, retryStrategyLibraryProvider, monitor, idempotentImportExecutor, retryingIdempotentImportExecutor, dtpInternalMetricRecorder, jobStore);
    }

    public void resetCopyIterationCounter() {
        COPY_ITERATION_COUNTER.set(0);
    }

    public void copy(AuthData exportAuthData, AuthData importAuthData, UUID jobId, Optional<ExportInformation> exportInfo) throws CopyException {
        this.idempotentImportExecutor.setJobId(jobId);
        String jobIdPrefix = "Job " + String.valueOf(jobId) + ": ";
        Optional maybeLoadedStack = this.jobStore.loadJobStack(jobId);
        if (maybeLoadedStack.isPresent()) {
            this.exportInfoStack = (Stack)maybeLoadedStack.get();
        } else {
            int initialCopyIteration = COPY_ITERATION_COUNTER.incrementAndGet();
            ExportResult initialExportResult = this.copyIteration(jobId, exportAuthData, importAuthData, exportInfo, jobIdPrefix, initialCopyIteration);
            ContainerResource exportContainerResource = exportInfo.map(ExportInformation::getContainerResource).orElse(null);
            this.updateStackAfterCopyIteration(jobId, jobIdPrefix, exportContainerResource, initialCopyIteration, initialExportResult.getContinuationData());
        }
        while (!this.exportInfoStack.isEmpty()) {
            int copyIteration = COPY_ITERATION_COUNTER.incrementAndGet();
            ExportInformation currentExportInfo = this.exportInfoStack.pop();
            ExportResult exportResult = this.copyIteration(jobId, exportAuthData, importAuthData, Optional.of(currentExportInfo), jobIdPrefix, copyIteration);
            this.updateStackAfterCopyIteration(jobId, jobIdPrefix, currentExportInfo.getContainerResource(), copyIteration, exportResult.getContinuationData());
        }
    }

    private void updateStackAfterCopyIteration(UUID jobId, String jobIdPrefix, ContainerResource exportContainerResource, int copyIteration, ContinuationData continuationData) {
        if (null != continuationData) {
            if (continuationData.getContainerResources() != null && !continuationData.getContainerResources().isEmpty()) {
                List subResources = continuationData.getContainerResources();
                for (int i = subResources.size() - 1; i >= 0; --i) {
                    this.monitor.debug(() -> jobIdPrefix + "Pushing to the stack a new copy iteration with a new container resource, copy iteration: " + copyIteration, new Object[0]);
                    this.exportInfoStack.push(new ExportInformation(null, (ContainerResource)subResources.get(i)));
                }
            }
            if (null != continuationData.getPaginationData()) {
                this.monitor.debug(() -> jobIdPrefix + "Pushing to the stack a new copy iteration with pagination info, copy iteration: " + copyIteration, new Object[0]);
                this.exportInfoStack.push(new ExportInformation(continuationData.getPaginationData(), exportContainerResource));
            }
        }
        this.jobStore.storeJobStack(jobId, (Stack)this.exportInfoStack.clone());
    }
}

