/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.launcher.monitor.events.EventCode;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.types.JobAuthorization;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.spi.transfer.hooks.JobHooks;
import org.datatransferproject.spi.transfer.provider.SignalHandler;
import org.datatransferproject.spi.transfer.provider.SignalRequest;
import org.datatransferproject.spi.transfer.security.AuthDataDecryptService;
import org.datatransferproject.spi.transfer.types.CopyException;
import org.datatransferproject.spi.transfer.types.CopyExceptionWithFailureReason;
import org.datatransferproject.spi.transfer.types.FailureReasons;
import org.datatransferproject.spi.transfer.types.signals.JobLifeCycle;
import org.datatransferproject.transfer.Annotations;
import org.datatransferproject.transfer.JobMetadata;
import org.datatransferproject.transfer.copier.InMemoryDataCopier;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.transfer.auth.AuthData;
import org.datatransferproject.types.transfer.auth.AuthDataPair;
import org.datatransferproject.types.transfer.errors.ErrorDetail;
import org.datatransferproject.types.transfer.retry.RetryException;

class JobProcessor {
    private final JobStore store;
    private final JobHooks hooks;
    private final ObjectMapper objectMapper;
    private final InMemoryDataCopier copier;
    private final AuthDataDecryptService decryptService;
    private final Provider<SignalHandler> exportSignalHandlerProvider;
    private final Provider<SignalHandler> importSignalHandlerProvider;
    private final Monitor monitor;
    private final DtpInternalMetricRecorder dtpInternalMetricRecorder;
    private final boolean transferSignalEnabled;

    @Inject
    JobProcessor(JobStore store, JobHooks hooks, ObjectMapper objectMapper, InMemoryDataCopier copier, AuthDataDecryptService decryptService, @Annotations.ExportSignalHandler Provider<SignalHandler> exportSignalHandlerProvider, @Annotations.ImportSignalHandler Provider<SignalHandler> importSignalHandlerProvider, @Named(value="transferSignalEnabled") Boolean transferSignalEnabled, Monitor monitor, DtpInternalMetricRecorder dtpInternalMetricRecorder) {
        this.store = store;
        this.hooks = hooks;
        this.objectMapper = objectMapper;
        this.copier = copier;
        this.decryptService = decryptService;
        this.exportSignalHandlerProvider = exportSignalHandlerProvider;
        this.importSignalHandlerProvider = importSignalHandlerProvider;
        this.monitor = monitor;
        this.dtpInternalMetricRecorder = dtpInternalMetricRecorder;
        this.transferSignalEnabled = transferSignalEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void processJob() {
        block13: {
            JobLifeCycle finalStatus;
            AuthDataDecryptService decryptService;
            JobAuthorization jobAuthorization;
            PortabilityJob job;
            AuthData importAuthData;
            AuthData exportAuthData;
            UUID jobId;
            boolean success;
            block12: {
                success = false;
                jobId = JobMetadata.getJobId();
                this.monitor.debug(() -> String.format("Begin processing jobId: %s", jobId), new Object[]{EventCode.WORKER_JOB_STARTED});
                exportAuthData = null;
                importAuthData = null;
                this.markJobStarted(jobId);
                this.hooks.jobStarted(jobId);
                job = this.store.findJob(jobId);
                jobAuthorization = job.jobAuthorization();
                this.monitor.debug(() -> String.format("Starting copy job, id: %s, source: %s, destination: %s", jobId, job.exportService(), job.importService()), new Object[0]);
                String scheme = jobAuthorization.encryptionScheme();
                decryptService = this.getAuthDecryptService(scheme);
                if (decryptService != null) break block12;
                this.monitor.severe(() -> String.format("No auth decrypter found for scheme %s while processing job: %s", scheme, jobId), new Object[0]);
                Collection<ErrorDetail> loggedErrors = this.copier.getErrors(jobId);
                int numErrors = loggedErrors.size();
                this.monitor.debug(() -> String.format("Finished processing jobId: %s with %d error(s).", jobId, numErrors), new Object[]{EventCode.WORKER_JOB_FINISHED});
                this.addErrorsAndMarkJobFinished(jobId, success &= loggedErrors.isEmpty(), loggedErrors);
                this.hooks.jobFinished(jobId, success);
                JobLifeCycle finalStatus2 = JobProcessor.deriveFinalJobStatus(success);
                this.sendSignals(jobId, exportAuthData, importAuthData, finalStatus2, this.monitor);
                this.dtpInternalMetricRecorder.finishedJob(JobMetadata.getDataType(), JobMetadata.getExportService(), JobMetadata.getImportService(), success, JobMetadata.getStopWatch().elapsed());
                this.monitor.flushLogs();
                JobMetadata.reset();
                return;
            }
            try {
                String encrypted = jobAuthorization.encryptedAuthData();
                byte[] encodedPrivateKey = JobMetadata.getPrivateKey();
                AuthDataPair pair = decryptService.decrypt(encrypted, encodedPrivateKey);
                exportAuthData = (AuthData)this.objectMapper.readValue(pair.getExportAuthData(), AuthData.class);
                importAuthData = (AuthData)this.objectMapper.readValue(pair.getImportAuthData(), AuthData.class);
                String exportInfoStr = job.exportInformation();
                Optional<ExportInformation> exportInfo = Optional.empty();
                if (!Strings.isNullOrEmpty((String)exportInfoStr)) {
                    exportInfo = Optional.ofNullable((ExportInformation)this.objectMapper.readValue(exportInfoStr, ExportInformation.class));
                }
                this.dtpInternalMetricRecorder.startedJob(JobMetadata.getDataType(), JobMetadata.getExportService(), JobMetadata.getImportService());
                JobMetadata.getStopWatch().start();
                this.sendSignals(jobId, exportAuthData, importAuthData, JobLifeCycle.JOB_STARTED(), this.monitor);
                this.copier.copy(exportAuthData, importAuthData, jobId, exportInfo);
                success = true;
            }
            catch (CopyExceptionWithFailureReason e) {
                String failureReason = e.getFailureReason();
                if (failureReason.contains(FailureReasons.DESTINATION_FULL.toString())) {
                    this.monitor.info(() -> "The remaining storage in the user's account is not enough to perform this operation.", new Object[]{e});
                } else if (failureReason.contains(FailureReasons.INVALID_TOKEN.toString()) || failureReason.contains(FailureReasons.SESSION_INVALIDATED.toString()) || failureReason.contains(FailureReasons.UNCONFIRMED_USER.toString()) || failureReason.contains(FailureReasons.USER_CHECKPOINTED.toString())) {
                    this.monitor.info(() -> "Got token error", new Object[]{e});
                } else {
                    this.monitor.severe(() -> String.format("Error with failure code '%s' while processing jobId: %s", failureReason, jobId), new Object[]{e, EventCode.WORKER_JOB_ERRORED});
                }
                this.addFailureReasonToJob(jobId, failureReason);
                Collection<ErrorDetail> loggedErrors = this.copier.getErrors(jobId);
                int numErrors = loggedErrors.size();
                this.monitor.debug(() -> String.format("Finished processing jobId: %s with %d error(s).", jobId, numErrors), new Object[]{EventCode.WORKER_JOB_FINISHED});
                this.addErrorsAndMarkJobFinished(jobId, success &= loggedErrors.isEmpty(), loggedErrors);
                this.hooks.jobFinished(jobId, success);
                finalStatus = JobProcessor.deriveFinalJobStatus(success);
                this.sendSignals(jobId, exportAuthData, importAuthData, finalStatus, this.monitor);
                this.dtpInternalMetricRecorder.finishedJob(JobMetadata.getDataType(), JobMetadata.getExportService(), JobMetadata.getImportService(), success, JobMetadata.getStopWatch().elapsed());
                this.monitor.flushLogs();
                JobMetadata.reset();
                break block13;
            }
            catch (IOException | RuntimeException | CopyException e2) {
                this.monitor.severe(() -> "Error processing jobId: " + jobId, new Object[]{e2, EventCode.WORKER_JOB_ERRORED});
                Collection<ErrorDetail> loggedErrors = this.copier.getErrors(jobId);
                int numErrors = loggedErrors.size();
                {
                    catch (Throwable throwable) {
                        Collection<ErrorDetail> loggedErrors2 = this.copier.getErrors(jobId);
                        int numErrors2 = loggedErrors2.size();
                        this.monitor.debug(() -> String.format("Finished processing jobId: %s with %d error(s).", jobId, numErrors), new Object[]{EventCode.WORKER_JOB_FINISHED});
                        this.addErrorsAndMarkJobFinished(jobId, success &= loggedErrors2.isEmpty(), loggedErrors2);
                        this.hooks.jobFinished(jobId, success);
                        JobLifeCycle finalStatus3 = JobProcessor.deriveFinalJobStatus(success);
                        this.sendSignals(jobId, exportAuthData, importAuthData, finalStatus3, this.monitor);
                        this.dtpInternalMetricRecorder.finishedJob(JobMetadata.getDataType(), JobMetadata.getExportService(), JobMetadata.getImportService(), success, JobMetadata.getStopWatch().elapsed());
                        this.monitor.flushLogs();
                        JobMetadata.reset();
                        throw throwable;
                    }
                }
                this.monitor.debug(() -> String.format("Finished processing jobId: %s with %d error(s).", jobId, numErrors), new Object[]{EventCode.WORKER_JOB_FINISHED});
                this.addErrorsAndMarkJobFinished(jobId, success &= loggedErrors.isEmpty(), loggedErrors);
                this.hooks.jobFinished(jobId, success);
                finalStatus = JobProcessor.deriveFinalJobStatus(success);
                this.sendSignals(jobId, exportAuthData, importAuthData, finalStatus, this.monitor);
                this.dtpInternalMetricRecorder.finishedJob(JobMetadata.getDataType(), JobMetadata.getExportService(), JobMetadata.getImportService(), success, JobMetadata.getStopWatch().elapsed());
                this.monitor.flushLogs();
                JobMetadata.reset();
            }
            Collection<ErrorDetail> loggedErrors = this.copier.getErrors(jobId);
            int numErrors = loggedErrors.size();
            this.monitor.debug(() -> String.format("Finished processing jobId: %s with %d error(s).", jobId, numErrors), new Object[]{EventCode.WORKER_JOB_FINISHED});
            this.addErrorsAndMarkJobFinished(jobId, success &= loggedErrors.isEmpty(), loggedErrors);
            this.hooks.jobFinished(jobId, success);
            finalStatus = JobProcessor.deriveFinalJobStatus(success);
            this.sendSignals(jobId, exportAuthData, importAuthData, finalStatus, this.monitor);
            this.dtpInternalMetricRecorder.finishedJob(JobMetadata.getDataType(), JobMetadata.getExportService(), JobMetadata.getImportService(), success, JobMetadata.getStopWatch().elapsed());
            this.monitor.flushLogs();
            JobMetadata.reset();
        }
    }

    private static JobLifeCycle deriveFinalJobStatus(boolean success) {
        return JobLifeCycle.builder().setState(JobLifeCycle.State.ENDED).setEndReason(success ? JobLifeCycle.EndReason.SUCCESSFULLY_COMPLETED : JobLifeCycle.EndReason.PARTIALLY_COMPLETED).build();
    }

    private void sendSignals(UUID jobId, AuthData exportAuthData, AuthData importAuthData, JobLifeCycle jobLifeCycle, Monitor monitor) {
        if (!this.transferSignalEnabled) {
            monitor.info(() -> "Transfer Signal Disabled.", new Object[0]);
            return;
        }
        SignalRequest signalRequest = SignalRequest.builder().setJobId(jobId.toString()).setDataType(JobMetadata.getDataType().getDataType()).setJobStatus(jobLifeCycle).setExportingService(JobMetadata.getExportService()).setImportingService(JobMetadata.getImportService()).build();
        try {
            ((SignalHandler)this.exportSignalHandlerProvider.get()).sendSignal(signalRequest, exportAuthData, monitor);
            ((SignalHandler)this.importSignalHandlerProvider.get()).sendSignal(signalRequest, importAuthData, monitor);
        }
        catch (IOException | CopyExceptionWithFailureReason | RetryException e) {
            monitor.info(() -> "Errored while sending transfer signals.", new Object[]{e});
        }
    }

    @Nullable
    private AuthDataDecryptService getAuthDecryptService(String scheme) {
        if (this.decryptService.canHandle(scheme)) {
            return this.decryptService;
        }
        return null;
    }

    private void addErrorsAndMarkJobFinished(UUID jobId, boolean success, Collection<ErrorDetail> errors) {
        try {
            this.store.addErrorsToJob(jobId, errors);
        }
        catch (IOException | RuntimeException e) {
            success = false;
            this.monitor.severe(() -> "Problem adding errors to JobStore", new Object[]{e});
        }
        try {
            this.store.markJobAsFinished(jobId, success ? PortabilityJob.State.COMPLETE : PortabilityJob.State.ERROR);
        }
        catch (IOException e) {
            this.monitor.severe(() -> String.format("Could not mark job %s as finished.", jobId), new Object[0]);
        }
    }

    private void addFailureReasonToJob(UUID jobId, String failureReason) {
        try {
            this.store.addFailureReasonToJob(jobId, failureReason);
        }
        catch (IOException e) {
            this.monitor.severe(() -> "Problem adding failure reason to JobStore", new Object[]{e});
        }
    }

    private void markJobStarted(UUID jobId) {
        try {
            this.store.markJobAsStarted(jobId);
        }
        catch (IOException e) {
            this.monitor.severe(() -> String.format("Could not mark job %s as %s", jobId, PortabilityJob.State.IN_PROGRESS), new Object[]{e});
        }
    }
}

