/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.inject.Provider;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.transfer.JobMetadata;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.transfer.auth.AuthData;

public class CallableExporter
implements Callable<ExportResult> {
    private Provider<Exporter> exporterProvider;
    private UUID jobId;
    private AuthData authData;
    private Optional<ExportInformation> exportInformation;
    private final DtpInternalMetricRecorder metricRecorder;

    public CallableExporter(Provider<Exporter> exporterProvider, UUID jobId, AuthData authData, Optional<ExportInformation> exportInformation, DtpInternalMetricRecorder metricRecorder) {
        this.exporterProvider = (Provider)Preconditions.checkNotNull(exporterProvider, (Object)"exportProvider can't be null");
        this.jobId = (UUID)Preconditions.checkNotNull((Object)jobId, (Object)"jobId can't be null");
        this.authData = (AuthData)Preconditions.checkNotNull((Object)authData, (Object)"authData can't be null");
        this.exportInformation = exportInformation;
        this.metricRecorder = (DtpInternalMetricRecorder)Preconditions.checkNotNull((Object)metricRecorder, (Object)"metric recorder can't be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportResult call() throws Exception {
        boolean success = false;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            ExportResult result = ((Exporter)this.exporterProvider.get()).export(this.jobId, this.authData, this.exportInformation);
            success = result.getType() != ExportResult.ResultType.ERROR;
            ExportResult exportResult = result;
            return exportResult;
        }
        finally {
            this.metricRecorder.exportPageAttemptFinished(JobMetadata.getDataType(), JobMetadata.getExportService(), success, stopwatch.elapsed());
        }
    }
}

