/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.datatransferproject.spi.api.transport.DiscardingStreamCounter;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.types.common.DownloadableItem;

public class CallableSizeCalculator
implements Callable<Map<String, Long>> {
    private final UUID jobId;
    private final ConnectionProvider connectionProvider;
    private final Collection<? extends DownloadableItem> items;

    public CallableSizeCalculator(UUID jobId, ConnectionProvider connectionProvider, Collection<? extends DownloadableItem> items) {
        this.jobId = Objects.requireNonNull(jobId);
        this.connectionProvider = Objects.requireNonNull(connectionProvider);
        this.items = Objects.requireNonNull(items);
    }

    @Override
    public Map<String, Long> call() throws Exception {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        for (DownloadableItem downloadableItem : this.items) {
            TemporaryPerJobDataStore.InputStreamWrapper stream = this.connectionProvider.getInputStreamForItem(this.jobId, downloadableItem);
            long size = stream.getBytes();
            if (size <= 0L) {
                size = DiscardingStreamCounter.discardForLength((InputStream)stream.getStream());
            }
            result.put(downloadableItem.getIdempotentId(), size);
        }
        return result;
    }
}

