/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.copier;

import com.google.cloud.datastore.DatastoreException;
import com.google.common.base.Stopwatch;
import com.google.inject.Provider;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.launcher.monitor.events.EventCode;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.CopyException;
import org.datatransferproject.spi.transfer.types.CopyExceptionWithFailureReason;
import org.datatransferproject.transfer.Annotations;
import org.datatransferproject.transfer.CallableExporter;
import org.datatransferproject.transfer.CallableImporter;
import org.datatransferproject.transfer.CallableSizeCalculator;
import org.datatransferproject.transfer.JobMetadata;
import org.datatransferproject.transfer.copier.InMemoryDataCopier;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.media.MediaContainerResource;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.common.models.videos.VideosContainerResource;
import org.datatransferproject.types.transfer.auth.AuthData;
import org.datatransferproject.types.transfer.errors.ErrorDetail;
import org.datatransferproject.types.transfer.retry.RetryException;
import org.datatransferproject.types.transfer.retry.RetryStrategyLibrary;
import org.datatransferproject.types.transfer.retry.RetryingCallable;

public abstract class PortabilityAbstractInMemoryDataCopier
implements InMemoryDataCopier {
    protected final Provider<Exporter> exporterProvider;
    protected final Provider<Importer> importerProvider;
    protected final IdempotentImportExecutor idempotentImportExecutor;
    protected final IdempotentImportExecutor retryingIdempotentImportExecutor;
    protected final Provider<RetryStrategyLibrary> retryStrategyLibraryProvider;
    protected final Monitor monitor;
    protected final DtpInternalMetricRecorder metricRecorder;
    protected final JobStore jobStore;

    public PortabilityAbstractInMemoryDataCopier(Provider<Exporter> exporterProvider, Provider<Importer> importerProvider, Provider<RetryStrategyLibrary> retryStrategyLibraryProvider, Monitor monitor, IdempotentImportExecutor idempotentImportExecutor, @Annotations.RetryingExecutor IdempotentImportExecutor retryingIdempotentImportExecutor, DtpInternalMetricRecorder dtpInternalMetricRecorder, JobStore jobStore) {
        this.exporterProvider = exporterProvider;
        this.importerProvider = importerProvider;
        this.retryStrategyLibraryProvider = retryStrategyLibraryProvider;
        this.monitor = monitor;
        this.idempotentImportExecutor = idempotentImportExecutor;
        this.retryingIdempotentImportExecutor = retryingIdempotentImportExecutor;
        this.metricRecorder = dtpInternalMetricRecorder;
        this.jobStore = jobStore;
    }

    public abstract void resetCopyIterationCounter();

    @Override
    public abstract void copy(AuthData var1, AuthData var2, UUID var3, Optional<ExportInformation> var4) throws IOException, CopyException;

    @Override
    public Collection<ErrorDetail> getErrors(UUID jobId) {
        this.idempotentImportExecutor.setJobId(jobId);
        this.retryingIdempotentImportExecutor.setJobId(jobId);
        return this.idempotentImportExecutor.getErrors();
    }

    protected ExportResult<?> copyIteration(UUID jobId, AuthData exportAuthData, AuthData importAuthData, Optional<ExportInformation> exportInformation, String jobIdPrefix, int copyIteration) throws CopyException {
        this.monitor.debug(() -> jobIdPrefix + "Copy iteration: " + copyIteration, new Object[0]);
        ExportResult<?> exportResult = this.exportIteration(jobId, exportAuthData, exportInformation, jobIdPrefix, copyIteration);
        DataModel exportedData = exportResult.getExportedData();
        if (exportedData != null) {
            PortabilityJob job = this.jobStore.findJob(jobId);
            PortabilityJob.TransferMode transferMode = job.transferMode() == null ? PortabilityJob.TransferMode.DATA_TRANSFER : job.transferMode();
            switch (transferMode) {
                case DATA_TRANSFER: {
                    this.importIteration(jobId, importAuthData, jobIdPrefix, copyIteration, exportedData);
                    break;
                }
                case SIZE_CALCULATION: {
                    this.sizeCalculationIteration(jobId, jobIdPrefix, exportedData);
                    break;
                }
                default: {
                    throw new IllegalStateException("Job mode " + transferMode.name() + " is not supported by " + this.getClass().getSimpleName());
                }
            }
        }
        return exportResult;
    }

    private ExportResult<?> exportIteration(UUID jobId, AuthData exportAuthData, Optional<ExportInformation> exportInformation, String jobIdPrefix, int copyIteration) throws CopyException {
        this.monitor.debug(() -> jobIdPrefix + "Starting export, copy iteration: " + copyIteration, new Object[]{EventCode.COPIER_STARTED_EXPORT});
        CallableExporter callableExporter = new CallableExporter(this.exporterProvider, jobId, exportAuthData, exportInformation, this.metricRecorder);
        RetryingCallable retryingExporter = new RetryingCallable((Callable)callableExporter, (RetryStrategyLibrary)this.retryStrategyLibraryProvider.get(), Clock.systemUTC(), this.monitor, JobMetadata.getDataType(), JobMetadata.getExportService());
        boolean exportSuccess = false;
        Stopwatch exportStopwatch = Stopwatch.createStarted();
        try {
            ExportResult exportResult = (ExportResult)retryingExporter.call();
            exportSuccess = exportResult.getType() != ExportResult.ResultType.ERROR;
            this.monitor.debug(() -> jobIdPrefix + "Finished export, copy iteration: " + copyIteration, new Object[]{EventCode.COPIER_FINISHED_EXPORT});
            ExportResult exportResult2 = exportResult;
            return exportResult2;
        }
        catch (RuntimeException | RetryException e) {
            throw this.convertToCopyException(jobIdPrefix, "export", (Exception)e);
        }
        finally {
            this.metricRecorder.exportPageFinished(JobMetadata.getDataType(), JobMetadata.getExportService(), exportSuccess, exportStopwatch.elapsed());
        }
    }

    private void importIteration(UUID jobId, AuthData importAuthData, String jobIdPrefix, int copyIteration, DataModel exportedData) throws CopyException {
        this.monitor.debug(() -> jobIdPrefix + "Starting import, copy iteration: " + copyIteration, new Object[]{EventCode.COPIER_STARTED_IMPORT});
        CallableImporter callableImporter = new CallableImporter(this.importerProvider, jobId, this.idempotentImportExecutor, importAuthData, exportedData, this.metricRecorder);
        RetryingCallable retryingImporter = new RetryingCallable((Callable)callableImporter, (RetryStrategyLibrary)this.retryStrategyLibraryProvider.get(), Clock.systemUTC(), this.monitor, JobMetadata.getDataType(), JobMetadata.getImportService());
        boolean importSuccess = false;
        Stopwatch importStopwatch = Stopwatch.createStarted();
        try {
            ImportResult importResult = (ImportResult)retryingImporter.call();
            boolean bl = importSuccess = importResult.getType() == ImportResult.ResultType.OK;
            if (importSuccess) {
                try {
                    this.jobStore.addCounts(jobId, (Map)importResult.getCounts().orElse(null));
                    this.jobStore.addBytes(jobId, (Long)importResult.getBytes().orElse(null));
                }
                catch (DatastoreException | IOException e) {
                    this.monitor.debug(() -> jobIdPrefix + "Unable to add counts to job: ", new Object[]{e});
                }
            }
            this.monitor.debug(() -> jobIdPrefix + "Finished import, copy iteration: " + copyIteration, new Object[]{EventCode.COPIER_FINISHED_IMPORT});
        }
        catch (RetryException e) {
            if (!e.canSkip()) {
                throw this.convertToCopyException(jobIdPrefix, "import", (Exception)((Object)e));
            }
        }
        catch (RuntimeException e) {
            throw this.convertToCopyException(jobIdPrefix, "import", e);
        }
        finally {
            this.metricRecorder.importPageFinished(JobMetadata.getDataType(), JobMetadata.getImportService(), importSuccess, importStopwatch.elapsed());
        }
    }

    private void sizeCalculationIteration(UUID jobId, String jobIdPrefix, DataModel exportedData) throws CopyException {
        ArrayList items;
        if (exportedData instanceof PhotosContainerResource) {
            items = ((PhotosContainerResource)exportedData).getPhotos();
        } else if (exportedData instanceof VideosContainerResource) {
            items = ((VideosContainerResource)exportedData).getVideos();
        } else if (exportedData instanceof MediaContainerResource) {
            MediaContainerResource mcr = (MediaContainerResource)exportedData;
            ArrayList list = new ArrayList(mcr.getVideos());
            list.addAll(mcr.getPhotos());
            items = list;
        } else {
            return;
        }
        CallableSizeCalculator callableSizeCalculator = new CallableSizeCalculator(jobId, new ConnectionProvider((TemporaryPerJobDataStore)this.jobStore), items);
        try {
            RetryingCallable retryingImporter = new RetryingCallable((Callable)callableSizeCalculator, (RetryStrategyLibrary)this.retryStrategyLibraryProvider.get(), Clock.systemUTC(), this.monitor, JobMetadata.getDataType(), JobMetadata.getImportService());
            this.jobStore.addBytes(jobId, (Map)retryingImporter.call());
        }
        catch (RuntimeException | RetryException e) {
            throw this.convertToCopyException(jobIdPrefix, "size estimation", (Exception)e);
        }
    }

    private CopyException convertToCopyException(String jobIdPrefix, String suffix, Exception e) {
        if (e.getClass() == RetryException.class && CopyExceptionWithFailureReason.class.isAssignableFrom(e.getCause().getClass())) {
            return (CopyExceptionWithFailureReason)e.getCause();
        }
        return new CopyException(jobIdPrefix + "Error happened during " + suffix, (Throwable)e);
    }
}

