/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.inject.Inject;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.launcher.monitor.events.EventCode;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.transfer.Annotations;
import org.datatransferproject.transfer.JobMetadata;

class JobCancelWatchingService
extends AbstractScheduledService {
    private final JobStore store;
    private final AbstractScheduledService.Scheduler scheduler;
    private final Monitor monitor;
    private final DtpInternalMetricRecorder dtpInternalMetricRecorder;

    @Inject
    JobCancelWatchingService(JobStore store, @Annotations.CancelScheduler AbstractScheduledService.Scheduler scheduler, Monitor monitor, DtpInternalMetricRecorder dtpInternalMetricRecorder) {
        this.store = store;
        this.scheduler = scheduler;
        this.monitor = monitor;
        this.dtpInternalMetricRecorder = dtpInternalMetricRecorder;
    }

    protected void runOneIteration() {
        if (!JobMetadata.isInitialized()) {
            return;
        }
        this.monitor.debug(() -> "polling for job to check cancellation", new Object[0]);
        PortabilityJob currentJob = this.store.findJob(JobMetadata.getJobId());
        switch (currentJob.state()) {
            case CANCELED: {
                this.monitor.info(() -> String.format("Job %s is canceled", JobMetadata.getJobId()), new Object[]{EventCode.WORKER_JOB_CANCELED});
                this.dtpInternalMetricRecorder.cancelledJob(JobMetadata.getDataType(), JobMetadata.getExportService(), JobMetadata.getImportService(), JobMetadata.getStopWatch().elapsed());
                this.monitor.flushLogs();
                this.store.abandonJob(JobMetadata.getJobId(), PortabilityJob.State.CANCELED.toString());
                System.exit(0);
                break;
            }
            case ERROR: {
                this.monitor.severe(() -> String.format("Job %s is errored", JobMetadata.getJobId()), new Object[]{EventCode.WATCHING_SERVICE_JOB_ERRORED});
                this.recordGeneralMetric(PortabilityJob.State.ERROR.toString());
                this.monitor.flushLogs();
                this.store.abandonJob(JobMetadata.getJobId(), PortabilityJob.State.ERROR.toString());
                System.exit(0);
                break;
            }
            case PREEMPTED: {
                this.monitor.info(() -> String.format("Job %s is preempted", JobMetadata.getJobId()), new Object[]{EventCode.WATCHING_SERVICE_JOB_PREEMPTED});
                this.recordGeneralMetric(PortabilityJob.State.PREEMPTED.toString());
                this.monitor.flushLogs();
                this.store.abandonJob(JobMetadata.getJobId(), PortabilityJob.State.PREEMPTED.toString());
                System.exit(0);
                break;
            }
            default: {
                this.monitor.debug(() -> String.format("Job %s is not canceled or errored or preempted", JobMetadata.getJobId()), new Object[0]);
            }
        }
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return this.scheduler;
    }

    private void recordGeneralMetric(String jobState) {
        this.dtpInternalMetricRecorder.recordGenericMetric(JobMetadata.getDataType(), JobMetadata.getExportService(), jobState, JobMetadata.getStopWatch().elapsed());
    }
}

