/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security;

import com.google.common.base.Preconditions;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.security.CryptoTransformation;
import org.datatransferproject.security.Decrypter;
import org.datatransferproject.security.DecrypterImpl;

public class DecrypterFactory {
    private Monitor monitor;

    public DecrypterFactory(Monitor monitor) {
        this.monitor = monitor;
    }

    public Decrypter create(SecretKey key) {
        Preconditions.checkArgument((boolean)key.getAlgorithm().equals("AES"));
        return new DecrypterImpl(CryptoTransformation.AES_CBC_NOPADDING, key, this.monitor);
    }

    public Decrypter create(PublicKey key) {
        Preconditions.checkArgument((boolean)key.getAlgorithm().equals("RSA"));
        return new DecrypterImpl(CryptoTransformation.RSA_ECB_PKCS1, key, this.monitor);
    }

    public Decrypter create(PrivateKey key) {
        Preconditions.checkArgument((boolean)key.getAlgorithm().equals("RSA"));
        return new DecrypterImpl(CryptoTransformation.RSA_ECB_PKCS1, key, this.monitor);
    }
}

