/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security;

import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.security.CryptoTransformation;
import org.datatransferproject.security.Decrypter;

final class DecrypterImpl
implements Decrypter {
    private final Key key;
    private final CryptoTransformation transformation;
    private final Monitor monitor;

    DecrypterImpl(CryptoTransformation transformation, Key key, Monitor monitor) {
        this.key = key;
        this.transformation = transformation;
        this.monitor = monitor;
    }

    @Override
    public String decrypt(String encrypted) {
        try {
            Cipher cipher;
            byte[] decoded = BaseEncoding.base64Url().decode((CharSequence)encrypted);
            switch (this.transformation) {
                case AES_CBC_NOPADDING: {
                    cipher = Cipher.getInstance("AES/CBC/NoPadding");
                    cipher.init(2, this.key, DecrypterImpl.generateIv(cipher));
                    break;
                }
                case RSA_ECB_PKCS1: {
                    cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                    cipher.init(2, this.key);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"How could this happen...");
                }
            }
            byte[] decrypted = cipher.doFinal(decoded);
            if (decrypted == null || decrypted.length <= cipher.getBlockSize()) {
                throw new RuntimeException("incorrect decrypted text.");
            }
            byte[] data = new byte[decrypted.length - cipher.getBlockSize()];
            System.arraycopy(decrypted, cipher.getBlockSize(), data, 0, data.length);
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            this.monitor.severe(() -> String.format("Error decrypting data, length: %s", encrypted.length()), new Object[]{e});
            throw new RuntimeException("Couldn't decrypt data", e);
        }
    }

    private static final IvParameterSpec generateIv(Cipher cipher) throws NoSuchAlgorithmException {
        SecureRandom randomSecureRandom = SecureRandom.getInstance("SHA1PRNG");
        byte[] iv = new byte[cipher.getBlockSize()];
        randomSecureRandom.nextBytes(iv);
        return new IvParameterSpec(iv);
    }
}

