/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security;

import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.security.SymmetricKeyGenerator;

public class AesSymmetricKeyGenerator
implements SymmetricKeyGenerator {
    private static final String ALGORITHM = "AES";
    private final Monitor monitor;

    public AesSymmetricKeyGenerator(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public SecretKey generate() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(ALGORITHM);
            return generator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            this.monitor.severe(() -> "NoSuchAlgorithmException for: AES", new Object[]{e});
            throw new RuntimeException("Error creating key generator", e);
        }
    }

    @Override
    public SecretKey parse(byte[] encoded) {
        return new SecretKeySpec(encoded, 0, encoded.length, ALGORITHM);
    }
}

