/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security;

import com.google.common.base.Preconditions;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.security.CryptoTransformation;
import org.datatransferproject.security.Encrypter;
import org.datatransferproject.security.EncrypterImpl;

public class EncrypterFactory {
    private Monitor monitor;

    public EncrypterFactory(Monitor monitor) {
        this.monitor = monitor;
    }

    public Encrypter create(SecretKey key) {
        Preconditions.checkArgument((boolean)key.getAlgorithm().equals("AES"));
        return new EncrypterImpl(CryptoTransformation.AES_CBC_NOPADDING, key, this.monitor);
    }

    public Encrypter create(PublicKey key) {
        Preconditions.checkArgument((boolean)key.getAlgorithm().equals("RSA"));
        return new EncrypterImpl(CryptoTransformation.RSA_ECB_PKCS1, key, this.monitor);
    }

    public Encrypter create(PrivateKey key) {
        Preconditions.checkArgument((boolean)key.getAlgorithm().equals("RSA"));
        return new EncrypterImpl(CryptoTransformation.RSA_ECB_PKCS1, key, this.monitor);
    }
}

