/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security;

import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.security.CryptoTransformation;
import org.datatransferproject.security.Encrypter;

final class EncrypterImpl
implements Encrypter {
    private final Key key;
    private final CryptoTransformation transformation;
    private final Monitor monitor;

    EncrypterImpl(CryptoTransformation transformation, Key key, Monitor monitor) {
        this.key = key;
        this.transformation = transformation;
        this.monitor = monitor;
    }

    @Override
    public String encrypt(String data) {
        try {
            Cipher cipher;
            switch (this.transformation) {
                case AES_CBC_NOPADDING: {
                    cipher = Cipher.getInstance("AES/CBC/NoPadding");
                    cipher.init(1, this.key, EncrypterImpl.generateIv(cipher));
                    break;
                }
                case RSA_ECB_PKCS1: {
                    cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                    cipher.init(1, this.key);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"How could this happen...");
                }
            }
            byte[] salt = new byte[cipher.getBlockSize()];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(salt);
            byte[] encryptedSalt = cipher.update(salt);
            byte[] encryptedData = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
            byte[] encrypted = new byte[encryptedSalt.length + encryptedData.length];
            System.arraycopy(encryptedSalt, 0, encrypted, 0, encryptedSalt.length);
            System.arraycopy(encryptedData, 0, encrypted, encryptedSalt.length, encryptedData.length);
            return BaseEncoding.base64Url().encode(encrypted);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            this.monitor.severe(() -> String.format("Exception encrypting data, length: %s", data.length()), new Object[]{e});
            throw new RuntimeException("Couldn't encrypt data", e);
        }
    }

    private static final IvParameterSpec generateIv(Cipher cipher) throws NoSuchAlgorithmException {
        SecureRandom randomSecureRandom = SecureRandom.getInstance("SHA1PRNG");
        byte[] iv = new byte[cipher.getBlockSize()];
        randomSecureRandom.nextBytes(iv);
        return new IvParameterSpec(iv);
    }
}

