/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.datavec.api.split.BaseInputSplit;
import org.datavec.api.util.RandomUtils;
import org.nd4j.linalg.collection.CompactHeapStringList;

public class FileSplit
extends BaseInputSplit {
    protected File rootDir;
    protected String[] allowFormat = null;
    protected boolean recursive = true;
    protected Random random;
    protected boolean randomize = false;

    protected FileSplit(File rootDir, String[] allowFormat, boolean recursive, Random random, boolean runMain) {
        this.allowFormat = allowFormat;
        this.recursive = recursive;
        this.rootDir = rootDir;
        if (random != null) {
            this.random = random;
            this.randomize = true;
        }
        if (runMain) {
            this.initialize();
        }
    }

    public FileSplit(File rootDir) {
        this(rootDir, null, true, null, true);
    }

    public FileSplit(File rootDir, Random rng) {
        this(rootDir, null, true, rng, true);
    }

    public FileSplit(File rootDir, String[] allowFormat) {
        this(rootDir, allowFormat, true, null, true);
    }

    public FileSplit(File rootDir, String[] allowFormat, Random rng) {
        this(rootDir, allowFormat, true, rng, true);
    }

    public FileSplit(File rootDir, String[] allowFormat, boolean recursive) {
        this(rootDir, allowFormat, recursive, null, true);
    }

    protected void initialize() {
        if (this.rootDir == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (this.rootDir.isDirectory()) {
            Collection subFiles = FileUtils.listFiles((File)this.rootDir, (String[])this.allowFormat, (boolean)this.recursive);
            this.uriStrings = new CompactHeapStringList();
            if (this.randomize) {
                this.iterationOrder = new int[subFiles.size()];
                for (int i = 0; i < this.iterationOrder.length; ++i) {
                    this.iterationOrder[i] = i;
                }
                RandomUtils.shuffleInPlace(this.iterationOrder, this.random);
            }
            for (File f : subFiles) {
                this.uriStrings.add(f.toURI().toString());
                this.length += f.length();
            }
        } else {
            String toString = this.rootDir.toURI().toString();
            this.uriStrings = Collections.singletonList(toString);
            this.length += this.rootDir.length();
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void reset() {
        if (this.randomize) {
            RandomUtils.shuffleInPlace(this.iterationOrder, this.random);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }

    public File getRootDir() {
        return this.rootDir;
    }
}

