/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.longtransform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.transform.BaseColumnsMathOpTransform;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class LongColumnsMathOpTransform
extends BaseColumnsMathOpTransform {
    public LongColumnsMathOpTransform(@JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="mathOp") MathOp mathOp, String ... columns) {
        super(newColumnName, mathOp, columns);
    }

    @Override
    protected ColumnMetaData derivedColumnMetaData(String newColumnName) {
        return new LongMetaData(newColumnName);
    }

    @Override
    protected Writable doOp(Writable ... input) {
        switch (this.mathOp) {
            case Add: {
                long sum = 0L;
                for (Writable w : input) {
                    sum += w.toLong();
                }
                return new LongWritable(sum);
            }
            case Subtract: {
                return new LongWritable(input[0].toLong() - input[1].toLong());
            }
            case Multiply: {
                long product = 1L;
                for (Writable w : input) {
                    product *= w.toLong();
                }
                return new LongWritable(product);
            }
            case Divide: {
                return new LongWritable(input[0].toLong() / input[1].toLong());
            }
            case Modulus: {
                return new LongWritable(input[0].toLong() % input[1].toLong());
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }

    @Override
    public String toString() {
        return "LongColumnsMathOpTransform(newColumnName=\"" + this.newColumnName + "\",mathOp=" + (Object)((Object)this.mathOp) + ",columns=" + Arrays.toString(this.columns) + ")";
    }

    @Override
    public Object map(Object input) {
        List list = (List)input;
        switch (this.mathOp) {
            case Add: {
                long sum = 0L;
                for (Long w : list) {
                    sum += w.longValue();
                }
                return new LongWritable(sum);
            }
            case Subtract: {
                return (Long)list.get(0) - (Long)list.get(1);
            }
            case Multiply: {
                long product = 1L;
                for (Long w : list) {
                    product *= w.longValue();
                }
                return product;
            }
            case Divide: {
                return (Long)list.get(0) / (Long)list.get(1);
            }
            case Modulus: {
                return (Long)list.get(0) % (Long)list.get(1);
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }

    @Override
    public Object mapSequence(Object sequence) {
        List seq = (List)sequence;
        ArrayList<Long> ret = new ArrayList<Long>();
        for (List l : seq) {
            ret.add((Long)this.map((Object)l));
        }
        return ret;
    }
}

