/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.jackson;

import java.util.List;
import org.datavec.api.records.reader.impl.LineRecordReader;
import org.datavec.api.records.reader.impl.jackson.FieldSelection;
import org.datavec.api.records.reader.impl.jackson.JacksonReaderUtils;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.databind.ObjectMapper;

public class JacksonLineRecordReader
extends LineRecordReader {
    private FieldSelection selection;
    private ObjectMapper mapper;

    public JacksonLineRecordReader(FieldSelection selection, ObjectMapper mapper) {
        this.selection = selection;
        this.mapper = mapper;
    }

    @Override
    public List<Writable> next() {
        Text t = (Text)super.next().iterator().next();
        String val = t.toString();
        return this.parseLine(val);
    }

    protected List<Writable> parseLine(String line) {
        return JacksonReaderUtils.parseRecord(line, this.selection, this.mapper);
    }

    @Override
    public List<String> getLabels() {
        throw new UnsupportedOperationException();
    }
}

