/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.split;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import lombok.NonNull;
import org.datavec.api.split.InputSplit;
import org.datavec.api.util.files.ShuffledListIterator;
import org.nd4j.common.function.Function;
import org.nd4j.common.util.MathUtils;

public class StreamInputSplit
implements InputSplit {
    protected List<URI> uris;
    protected Function<URI, InputStream> streamCreatorFn;
    protected Random rng;
    protected int[] order;

    public StreamInputSplit(@NonNull List<URI> uris, @NonNull Function<URI, InputStream> streamCreatorFn) {
        this(uris, streamCreatorFn, null);
        if (uris == null) {
            throw new NullPointerException("uris is marked non-null but is null");
        }
        if (streamCreatorFn == null) {
            throw new NullPointerException("streamCreatorFn is marked non-null but is null");
        }
    }

    public StreamInputSplit(@NonNull List<URI> uris, @NonNull Function<URI, InputStream> streamCreatorFn, Random rng) {
        if (uris == null) {
            throw new NullPointerException("uris is marked non-null but is null");
        }
        if (streamCreatorFn == null) {
            throw new NullPointerException("streamCreatorFn is marked non-null but is null");
        }
        this.uris = uris;
        this.streamCreatorFn = streamCreatorFn;
        this.rng = rng;
    }

    @Override
    public boolean canWriteToLocation(URI location) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String addNewLocation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String addNewLocation(String location) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSplitLocations(boolean reset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean needsBootstrapForWrite() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bootStrapForWrite() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream openOutputStreamFor(String location) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream openInputStreamFor(String location) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public long length() {
        return this.uris.size();
    }

    @Override
    public URI[] locations() {
        return this.uris.toArray(new URI[this.uris.size()]);
    }

    @Override
    public Iterator<URI> locationsIterator() {
        if (this.rng == null) {
            return this.uris.iterator();
        }
        if (this.order == null) {
            this.order = new int[this.uris.size()];
            for (int i = 0; i < this.order.length; ++i) {
                this.order[i] = i;
            }
        }
        MathUtils.shuffleArray((int[])this.order, (Random)this.rng);
        return new ShuffledListIterator<URI>(this.uris, this.order);
    }

    @Override
    public Iterator<String> locationsPathIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    public List<URI> getUris() {
        return this.uris;
    }

    public Function<URI, InputStream> getStreamCreatorFn() {
        return this.streamCreatorFn;
    }

    public Random getRng() {
        return this.rng;
    }

    public int[] getOrder() {
        return this.order;
    }

    public void setUris(List<URI> uris) {
        this.uris = uris;
    }

    public void setStreamCreatorFn(Function<URI, InputStream> streamCreatorFn) {
        this.streamCreatorFn = streamCreatorFn;
    }

    public void setRng(Random rng) {
        this.rng = rng;
    }

    public void setOrder(int[] order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamInputSplit)) {
            return false;
        }
        StreamInputSplit other = (StreamInputSplit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<URI> this$uris = this.getUris();
        List<URI> other$uris = other.getUris();
        if (this$uris == null ? other$uris != null : !((Object)this$uris).equals(other$uris)) {
            return false;
        }
        Function<URI, InputStream> this$streamCreatorFn = this.getStreamCreatorFn();
        Function<URI, InputStream> other$streamCreatorFn = other.getStreamCreatorFn();
        if (this$streamCreatorFn == null ? other$streamCreatorFn != null : !this$streamCreatorFn.equals(other$streamCreatorFn)) {
            return false;
        }
        Random this$rng = this.getRng();
        Random other$rng = other.getRng();
        if (this$rng == null ? other$rng != null : !this$rng.equals(other$rng)) {
            return false;
        }
        return Arrays.equals(this.getOrder(), other.getOrder());
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamInputSplit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<URI> $uris = this.getUris();
        result = result * 59 + ($uris == null ? 43 : ((Object)$uris).hashCode());
        Function<URI, InputStream> $streamCreatorFn = this.getStreamCreatorFn();
        result = result * 59 + ($streamCreatorFn == null ? 43 : $streamCreatorFn.hashCode());
        Random $rng = this.getRng();
        result = result * 59 + ($rng == null ? 43 : $rng.hashCode());
        result = result * 59 + Arrays.hashCode(this.getOrder());
        return result;
    }

    public String toString() {
        return "StreamInputSplit(uris=" + this.getUris() + ", streamCreatorFn=" + this.getStreamCreatorFn() + ", rng=" + this.getRng() + ", order=" + Arrays.toString(this.getOrder()) + ")";
    }
}

