/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FloatColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final Float value;
    private final Set<Float> set;

    public FloatColumnCondition(String columnName, ConditionOp op, float value) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public FloatColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, float value) {
        super(column, sequenceConditionMode);
        if (op == ConditionOp.InSet || op == ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: cannot use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = Float.valueOf(value);
        this.set = null;
    }

    public FloatColumnCondition(String column, ConditionOp op, Set<Float> set) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    public FloatColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<Float> set) {
        super(column, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = null;
        this.set = set;
    }

    private FloatColumnCondition(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="op") ConditionOp op, @JsonProperty(value="value") float value, @JsonProperty(value="set") Set<Float> set) {
        super(columnName, DEFAULT_SEQUENCE_CONDITION_MODE);
        this.op = op;
        this.value = set == null ? Float.valueOf(value) : null;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        return this.op.apply(writable.toFloat(), this.value == null ? Float.NaN : this.value.floatValue(), this.set);
    }

    @Override
    public String toString() {
        return "FloatColumnCondition(columnName=\"" + this.columnName + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : this.value) + ")";
    }

    @Override
    public boolean condition(Object input) {
        Number d = (Number)input;
        return this.op.apply(d.floatValue(), this.value == null ? Float.NaN : this.value.floatValue(), this.set);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatColumnCondition)) {
            return false;
        }
        FloatColumnCondition other = (FloatColumnCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$value = this.getValue();
        Float other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        ConditionOp this$op = this.getOp();
        ConditionOp other$op = other.getOp();
        if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
            return false;
        }
        Set<Float> this$set = this.getSet();
        Set<Float> other$set = other.getSet();
        return !(this$set == null ? other$set != null : !((Object)this$set).equals(other$set));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FloatColumnCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        ConditionOp $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
        Set<Float> $set = this.getSet();
        result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
        return result;
    }

    public ConditionOp getOp() {
        return this.op;
    }

    public Float getValue() {
        return this.value;
    }

    public Set<Float> getSet() {
        return this.set;
    }
}

