/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.split.partition;

import java.io.OutputStream;
import java.net.URI;
import org.datavec.api.conf.Configuration;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.partition.PartitionMetaData;
import org.datavec.api.split.partition.Partitioner;

public class NumberOfRecordsPartitioner
implements Partitioner {
    private URI[] locations;
    private int recordsPerFile = -1;
    public static final int DEFAULT_RECORDS_PER_FILE = -1;
    public static final String RECORDS_PER_FILE_CONFIG = "org.datavec.api.split.partition.numrecordsperfile";
    private int numRecordsSoFar = 0;
    private int currLocation;
    private InputSplit inputSplit;
    private OutputStream current;
    private boolean doneWithCurrentLocation = false;
    private int totalRecordsWritten;

    @Override
    public int totalRecordsWritten() {
        return this.totalRecordsWritten;
    }

    @Override
    public int numRecordsWritten() {
        return this.numRecordsSoFar;
    }

    @Override
    public int numPartitions() {
        if (this.locations.length < 2) {
            if (this.locations.length > 0 && this.locations[0].isAbsolute()) {
                return this.recordsPerFile;
            }
            return 1;
        }
        return this.locations.length / this.recordsPerFile;
    }

    @Override
    public void init(InputSplit inputSplit) {
        this.locations = inputSplit.locations();
        this.inputSplit = inputSplit;
    }

    @Override
    public void init(Configuration configuration, InputSplit split) {
        this.init(split);
        this.recordsPerFile = configuration.getInt(RECORDS_PER_FILE_CONFIG, -1);
    }

    @Override
    public void updatePartitionInfo(PartitionMetaData metadata) {
        this.numRecordsSoFar += metadata.getNumRecordsUpdated();
        this.totalRecordsWritten += metadata.getNumRecordsUpdated();
        if (this.numRecordsSoFar >= this.recordsPerFile && this.recordsPerFile > 0) {
            this.doneWithCurrentLocation = true;
        }
    }

    @Override
    public boolean needsNewPartition() {
        this.doneWithCurrentLocation = this.numRecordsSoFar >= this.recordsPerFile && this.recordsPerFile > 0;
        return this.recordsPerFile > 0 && this.numRecordsSoFar >= this.recordsPerFile || this.doneWithCurrentLocation;
    }

    @Override
    public OutputStream openNewStream() {
        this.doneWithCurrentLocation = false;
        this.numRecordsSoFar = 0;
        if (this.currLocation >= this.locations.length - 1 && this.locations.length >= 1 && this.needsNewPartition() || this.inputSplit.needsBootstrapForWrite() || this.locations.length < 1 || this.currLocation >= this.locations.length || !this.inputSplit.canWriteToLocation(this.locations[this.currLocation]) && this.needsNewPartition()) {
            String newInput = this.inputSplit.addNewLocation();
            try {
                OutputStream ret;
                this.current = ret = this.inputSplit.openOutputStreamFor(newInput);
                return ret;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            OutputStream ret = this.inputSplit.openOutputStreamFor(this.locations[this.currLocation].toString());
            ++this.currLocation;
            this.current = ret;
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public OutputStream currentOutputStream() {
        if (this.current == null) {
            this.current = this.openNewStream();
        }
        return this.current;
    }
}

