/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.split;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.datavec.api.split.BaseInputSplit;
import org.datavec.api.util.files.URIUtil;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.collection.CompactHeapStringList;
import org.nd4j.linalg.util.MathUtils;

public class FileSplit
extends BaseInputSplit {
    protected File rootDir;
    protected String[] allowFormat = null;
    protected boolean recursive = true;
    protected Random random;
    protected boolean randomize = false;

    protected FileSplit(File rootDir, String[] allowFormat, boolean recursive, Random random, boolean runMain) {
        this.allowFormat = allowFormat;
        this.recursive = recursive;
        this.rootDir = rootDir;
        if (random != null) {
            this.random = random;
            this.randomize = true;
        }
        if (runMain) {
            this.initialize();
        }
    }

    public FileSplit(File rootDir) {
        this(rootDir, null, true, null, true);
    }

    public FileSplit(File rootDir, Random rng) {
        this(rootDir, null, true, rng, true);
    }

    public FileSplit(File rootDir, String[] allowFormat) {
        this(rootDir, allowFormat, true, null, true);
    }

    public FileSplit(File rootDir, String[] allowFormat, Random rng) {
        this(rootDir, allowFormat, true, rng, true);
    }

    public FileSplit(File rootDir, String[] allowFormat, boolean recursive) {
        this(rootDir, allowFormat, recursive, null, true);
    }

    protected void initialize() {
        if (this.rootDir == null) {
            throw new IllegalArgumentException("File path must not be null");
        }
        if (this.rootDir.isAbsolute() && !this.rootDir.exists()) {
            try {
                if (!this.rootDir.createNewFile()) {
                    throw new IllegalArgumentException("Unable to create file " + this.rootDir.getAbsolutePath());
                }
                this.uriStrings = new ArrayList();
                this.uriStrings.add(this.rootDir.toURI().toString());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            if (!this.rootDir.getAbsoluteFile().exists()) {
                throw new IllegalArgumentException("No such file or directory: " + this.rootDir.getAbsolutePath());
            }
            if (this.rootDir.isDirectory()) {
                List<File> list = this.listFiles(this.rootDir, this.allowFormat, this.recursive);
                this.uriStrings = new CompactHeapStringList();
                if (this.randomize) {
                    this.iterationOrder = new int[list.size()];
                    for (int i = 0; i < this.iterationOrder.length; ++i) {
                        this.iterationOrder[i] = i;
                    }
                    MathUtils.shuffleArray((int[])this.iterationOrder, (Random)this.random);
                }
                for (File f : list) {
                    this.uriStrings.add(URIUtil.fileToURI(f).toString());
                    ++this.length;
                }
            } else {
                String toString = URIUtil.fileToURI(this.rootDir).toString();
                this.uriStrings = new ArrayList(1);
                this.uriStrings.add(toString);
                this.length += this.rootDir.length();
            }
        }
    }

    @Override
    public String addNewLocation() {
        if (this.rootDir.isDirectory()) {
            return this.addNewLocation(new File(this.rootDir, UUID.randomUUID().toString()).toURI().toString());
        }
        return this.addNewLocation(new File(this.rootDir.getParent(), UUID.randomUUID().toString() + "." + FilenameUtils.getExtension((String)this.rootDir.getAbsolutePath())).toURI().toString());
    }

    @Override
    public String addNewLocation(String location) {
        File f = new File(URI.create(location));
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.uriStrings.add(location);
        ++this.length;
        return location;
    }

    @Override
    public void updateSplitLocations(boolean reset) {
        if (reset) {
            this.initialize();
        }
    }

    @Override
    public boolean needsBootstrapForWrite() {
        return this.locations() == null || this.locations().length < 1 || this.locations().length == 1 && !this.locations()[0].isAbsolute();
    }

    @Override
    public void bootStrapForWrite() {
        if (this.locations().length == 1 && !this.locations()[0].isAbsolute()) {
            File parentDir = new File(this.locations()[0]);
            File writeFile = new File(parentDir, "write-file");
            try {
                writeFile.createNewFile();
                this.uriStrings.add(writeFile.toURI().toString());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public OutputStream openOutputStreamFor(String location) throws Exception {
        FileOutputStream ret = location.startsWith("file:") ? new FileOutputStream(new File(URI.create(location))) : new FileOutputStream(new File(location));
        return ret;
    }

    @Override
    public InputStream openInputStreamFor(String location) throws Exception {
        FileInputStream ret = location.startsWith("file:") ? new FileInputStream(new File(URI.create(location))) : new FileInputStream(new File(location));
        return ret;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void reset() {
        if (this.randomize) {
            MathUtils.shuffleArray((int[])this.iterationOrder, (Random)this.random);
        }
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    private List<File> listFiles(File dir, String[] allowedFormats, boolean recursive) {
        Preconditions.checkState((boolean)dir.isDirectory(), (String)"Argument is not a directory: %s", (Object)dir);
        Object filter = allowedFormats == null ? new RegexFileFilter(".*") : new SuffixFileFilter(allowedFormats);
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(dir);
        ArrayList<File> out = new ArrayList<File>();
        while (!queue.isEmpty()) {
            File[] listFiles = ((File)queue.remove()).listFiles();
            if (listFiles == null) continue;
            for (File f : listFiles) {
                boolean isDir = f.isDirectory();
                if (isDir && recursive) {
                    queue.add(f);
                    continue;
                }
                if (isDir || !filter.accept(f)) continue;
                out.add(f);
            }
        }
        return out;
    }
}

