/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.transform;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.listener.RecordListener;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.transform.TransformProcess;
import org.datavec.api.writable.Writable;

public class TransformProcessSequenceRecordReader
implements SequenceRecordReader {
    protected SequenceRecordReader sequenceRecordReader;
    protected TransformProcess transformProcess;

    @Override
    public void setConf(Configuration conf) {
        this.sequenceRecordReader.setConf(conf);
    }

    @Override
    public Configuration getConf() {
        return this.sequenceRecordReader.getConf();
    }

    @Override
    public List<List<Writable>> sequenceRecord() {
        return this.transformProcess.executeSequence(this.sequenceRecordReader.sequenceRecord());
    }

    @Override
    public boolean batchesSupported() {
        return false;
    }

    @Override
    public List<List<Writable>> next(int num) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        return this.transformProcess.executeSequence(this.sequenceRecordReader.sequenceRecord(uri, dataInputStream));
    }

    @Override
    public SequenceRecord nextSequence() {
        SequenceRecord next = this.sequenceRecordReader.nextSequence();
        next.setSequenceRecord(this.transformProcess.executeSequence(next.getSequenceRecord()));
        return next;
    }

    @Override
    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        SequenceRecord next = this.sequenceRecordReader.loadSequenceFromMetaData(recordMetaData);
        next.setSequenceRecord(this.transformProcess.executeSequence(next.getSequenceRecord()));
        return next;
    }

    @Override
    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        return null;
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public List<Writable> next() {
        return this.transformProcess.execute(this.sequenceRecordReader.next());
    }

    @Override
    public boolean hasNext() {
        return this.sequenceRecordReader.hasNext();
    }

    @Override
    public List<String> getLabels() {
        return this.sequenceRecordReader.getLabels();
    }

    @Override
    public void reset() {
        this.sequenceRecordReader.reset();
    }

    @Override
    public boolean resetSupported() {
        return this.sequenceRecordReader.resetSupported();
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        return this.transformProcess.execute(this.sequenceRecordReader.record(uri, dataInputStream));
    }

    @Override
    public Record nextRecord() {
        Record next = this.sequenceRecordReader.nextRecord();
        next.setRecord(this.transformProcess.execute(next.getRecord()));
        return next;
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        Record load = this.sequenceRecordReader.loadFromMetaData(recordMetaData);
        load.setRecord(this.transformProcess.execute(load.getRecord()));
        return load;
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        List<Record> records = this.sequenceRecordReader.loadFromMetaData(recordMetaDatas);
        for (Record record : records) {
            record.setRecord(this.transformProcess.execute(record.getRecord()));
        }
        return records;
    }

    @Override
    public List<RecordListener> getListeners() {
        return this.sequenceRecordReader.getListeners();
    }

    @Override
    public void setListeners(RecordListener ... listeners) {
        this.sequenceRecordReader.setListeners(listeners);
    }

    @Override
    public void setListeners(Collection<RecordListener> listeners) {
        this.sequenceRecordReader.setListeners(listeners);
    }

    @Override
    public void close() throws IOException {
        this.sequenceRecordReader.close();
    }

    public TransformProcessSequenceRecordReader(SequenceRecordReader sequenceRecordReader, TransformProcess transformProcess) {
        this.sequenceRecordReader = sequenceRecordReader;
        this.transformProcess = transformProcess;
    }
}

