/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.histogram;

import org.datavec.api.transform.analysis.histogram.HistogramCounter;
import org.datavec.api.writable.Writable;

public class DoubleHistogramCounter
implements HistogramCounter {
    private final double minValue;
    private final double maxValue;
    private final int nBins;
    private final double[] bins;
    private final long[] binCounts;

    public DoubleHistogramCounter(double minValue, double maxValue, int nBins) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.nBins = nBins;
        this.bins = new double[nBins + 1];
        double step = (maxValue - minValue) / (double)nBins;
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i] = i == this.bins.length - 1 ? maxValue : minValue + (double)i * step;
        }
        this.binCounts = new long[nBins];
    }

    @Override
    public HistogramCounter add(Writable w) {
        double d = w.toDouble();
        int idx = -1;
        for (int i = 0; i < this.nBins; ++i) {
            if (!(d >= this.bins[i]) || !(d < this.bins[i + 1])) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            idx = this.nBins - 1;
        }
        int n = idx;
        this.binCounts[n] = this.binCounts[n] + 1L;
        return this;
    }

    @Override
    public DoubleHistogramCounter merge(HistogramCounter other) {
        if (other == null) {
            return this;
        }
        if (!(other instanceof DoubleHistogramCounter)) {
            throw new IllegalArgumentException("Cannot merge " + other);
        }
        DoubleHistogramCounter o = (DoubleHistogramCounter)other;
        if (this.minValue != o.minValue || this.maxValue != o.maxValue) {
            throw new IllegalStateException("Min/max values differ: (" + this.minValue + "," + this.maxValue + ")  vs. (" + o.minValue + "," + o.maxValue + ")");
        }
        if (this.nBins != o.nBins) {
            throw new IllegalStateException("Different number of bins: " + this.nBins + " vs " + o.nBins);
        }
        for (int i = 0; i < this.nBins; ++i) {
            int n = i;
            this.binCounts[n] = this.binCounts[n] + o.binCounts[i];
        }
        return this;
    }

    @Override
    public double[] getBins() {
        return this.bins;
    }

    @Override
    public long[] getCounts() {
        return this.binCounts;
    }
}

