/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.json;

import com.tdunning.math.stats.TDigest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.codec.binary.Base64;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;

public class TDigestDeserializer
extends JsonDeserializer<TDigest> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TDigest deserialize(JsonParser jp, DeserializationContext d) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String field = node.get("digest").asText();
        Base64 b = new Base64();
        byte[] bytes = b.decode(field);
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            TDigest tDigest = (TDigest)ois.readObject();
            return tDigest;
        }
        catch (Exception e) {
            throw new RuntimeException("Error deserializing TDigest object from JSON", e);
        }
    }
}

