/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.arrow.recordreader;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.batch.AbstractWritableRecordBatch;
import org.datavec.arrow.ArrowConverter;

public class ArrowWritableRecordBatch
extends AbstractWritableRecordBatch
implements Closeable {
    private List<FieldVector> list;
    private int size;
    private Schema schema;
    private ArrowRecordBatch arrowRecordBatch;
    private VectorSchemaRoot vectorLoader;
    private VectorUnloader unloader;
    private int offset;
    private int rows;

    public ArrowWritableRecordBatch(List<FieldVector> list, Schema schema, int offset, int rows) {
        this.list = list;
        this.schema = schema;
        this.offset = offset;
        this.size = rows;
    }

    public ArrowWritableRecordBatch(List<FieldVector> list, Schema schema) {
        this(list, schema, 0, list.get(0).getValueCount());
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    public Iterator<List<Writable>> iterator() {
        return new ArrowListIterator();
    }

    public Object[] toArray() {
        Object[] ret = new Object[this.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.get(i);
        }
        return ret;
    }

    public <T> T[] toArray(T[] ts) {
        throw new UnsupportedOperationException();
    }

    public boolean add(List<Writable> writable) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends List<Writable>> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int i, Collection<? extends List<Writable>> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
    }

    public List<Writable> get(int i) {
        ArrayList<Writable> ret = new ArrayList<Writable>(this.schema.numColumns());
        for (int column = 0; column < this.schema.numColumns(); ++column) {
            try {
                if (!this.list.get(column).isNull(this.offset + i)) {
                    ret.add(ArrowConverter.fromEntry(this.offset + i, this.list.get(column), this.schema.getType(column)));
                    continue;
                }
                ret.add((Writable)NullWritable.INSTANCE);
                continue;
            }
            catch (Exception e) {
                ret.add((Writable)NullWritable.INSTANCE);
            }
        }
        return ret;
    }

    public List<Writable> set(int i, List<Writable> writable) {
        int rowOffset = this.offset + i;
        Object old = this.get(i);
        if (writable.size() != this.schema.numColumns()) {
            throw new IllegalArgumentException("Unable to set value. Wrong input types coming in");
        }
        int colIdx = 0;
        for (FieldVector fieldVector : this.list) {
            ArrowConverter.setValue(this.schema.getType(colIdx), fieldVector, writable.get(colIdx), rowOffset);
            ++colIdx;
        }
        return old;
    }

    public void add(int i, List<Writable> writable) {
        throw new UnsupportedOperationException();
    }

    public List<Writable> remove(int i) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    public ListIterator<List<Writable>> listIterator() {
        return new ArrowListIterator();
    }

    public ListIterator<List<Writable>> listIterator(int i) {
        throw new UnsupportedOperationException();
    }

    public List<List<Writable>> subList(int i, int i1) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrowWritableRecordBatch lists = (ArrowWritableRecordBatch)o;
        return this.size == lists.size && Objects.equals(this.list, lists.list) && Objects.equals(this.schema, lists.schema);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.list, this.size, this.schema);
    }

    @Override
    public void close() throws IOException {
        if (this.arrowRecordBatch != null) {
            this.arrowRecordBatch.close();
        }
        if (this.vectorLoader != null) {
            this.vectorLoader.close();
        }
    }

    public List<List<Writable>> toArrayList() {
        ArrayList<List<Writable>> ret = new ArrayList<List<Writable>>();
        for (int i = 0; i < this.size(); ++i) {
            ArrayList add = new ArrayList();
            add.addAll(this.get(i));
            ret.add(add);
        }
        return ret;
    }

    public List<FieldVector> getList() {
        return this.list;
    }

    public int getSize() {
        return this.size;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public ArrowRecordBatch getArrowRecordBatch() {
        return this.arrowRecordBatch;
    }

    public VectorSchemaRoot getVectorLoader() {
        return this.vectorLoader;
    }

    public VectorUnloader getUnloader() {
        return this.unloader;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getRows() {
        return this.rows;
    }

    public void setList(List<FieldVector> list) {
        this.list = list;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setArrowRecordBatch(ArrowRecordBatch arrowRecordBatch) {
        this.arrowRecordBatch = arrowRecordBatch;
    }

    public void setVectorLoader(VectorSchemaRoot vectorLoader) {
        this.vectorLoader = vectorLoader;
    }

    public void setUnloader(VectorUnloader unloader) {
        this.unloader = unloader;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String toString() {
        return "ArrowWritableRecordBatch(list=" + this.getList() + ", size=" + this.getSize() + ", schema=" + this.getSchema() + ", arrowRecordBatch=" + this.getArrowRecordBatch() + ", vectorLoader=" + this.getVectorLoader() + ", unloader=" + this.getUnloader() + ", offset=" + this.getOffset() + ", rows=" + this.getRows() + ")";
    }

    public ArrowWritableRecordBatch(List<FieldVector> list, int size, Schema schema, ArrowRecordBatch arrowRecordBatch, VectorSchemaRoot vectorLoader, VectorUnloader unloader, int offset, int rows) {
        this.list = list;
        this.size = size;
        this.schema = schema;
        this.arrowRecordBatch = arrowRecordBatch;
        this.vectorLoader = vectorLoader;
        this.unloader = unloader;
        this.offset = offset;
        this.rows = rows;
    }

    private class ArrowListIterator
    implements ListIterator<List<Writable>> {
        private int index;

        private ArrowListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ArrowWritableRecordBatch.this.size;
        }

        @Override
        public List<Writable> next() {
            return ArrowWritableRecordBatch.this.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public List<Writable> previous() {
            return ArrowWritableRecordBatch.this.get(this.index - 1);
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(List<Writable> writables) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(List<Writable> writables) {
            throw new UnsupportedOperationException();
        }
    }
}

