/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.cli.csv.schema;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.math3.util.Pair;
import org.datavec.cli.csv.schema.CSVSchemaColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVInputSchema {
    private static final Logger log = LoggerFactory.getLogger(CSVInputSchema.class);
    public String relation = "";
    public String delimiter = "";
    private boolean hasComputedStats = false;
    private Map<String, CSVSchemaColumn> columnSchemas = new LinkedHashMap<String, CSVSchemaColumn>();

    public CSVSchemaColumn getColumnSchemaByName(String colName) {
        return this.columnSchemas.get(colName);
    }

    public Map<String, CSVSchemaColumn> getColumnSchemas() {
        return this.columnSchemas;
    }

    private boolean validateRelationLine(String[] lineParts) {
        return lineParts.length == 2;
    }

    private boolean validateDelimiterLine(String[] lineParts) {
        return lineParts.length == 2;
    }

    private boolean validateAttributeLine(String[] lineParts) {
        if (lineParts.length != 4) {
            return false;
        }
        CSVSchemaColumn colValue = this.parseColumnSchemaFromAttribute(lineParts);
        if (colValue.columnType == CSVSchemaColumn.ColumnType.NOMINAL && colValue.transform == CSVSchemaColumn.TransformType.BINARIZE) {
            return false;
        }
        return colValue.columnType != CSVSchemaColumn.ColumnType.DATE;
    }

    private boolean validateSchemaLine(String line) {
        String lineCondensed = line.trim().replaceAll(" +", " ");
        String[] parts = lineCondensed.split(" ");
        if (parts[0].toLowerCase().equals("@relation")) {
            return this.validateRelationLine(parts);
        }
        if (parts[0].toLowerCase().equals("@delimiter")) {
            return this.validateDelimiterLine(parts);
        }
        if (parts[0].toLowerCase().equals("@attribute")) {
            return this.validateAttributeLine(parts);
        }
        if (parts[0].trim().equals("")) {
            return true;
        }
        log.error("Line attribute matched no known attribute in schema! --- {}", (Object)line);
        return false;
    }

    private String parseRelationInformation(String[] parts) {
        return parts[1];
    }

    private String parseDelimiter(String[] parts) {
        return parts[1];
    }

    private CSVSchemaColumn parseColumnSchemaFromAttribute(String[] parts) {
        String columnName = parts[1];
        String columnType = parts[2];
        String columnTransform = parts[3];
        CSVSchemaColumn.ColumnType colTypeEnum = CSVSchemaColumn.ColumnType.valueOf(columnType.toUpperCase());
        CSVSchemaColumn.TransformType colTransformEnum = CSVSchemaColumn.TransformType.valueOf(columnTransform.toUpperCase().substring(1));
        return new CSVSchemaColumn(columnName, colTypeEnum, colTransformEnum);
    }

    private void addSchemaLine(String line) {
        String lineCondensed = line.trim().replaceAll(" +", " ");
        String[] parts = lineCondensed.split(" ");
        if (parts[0].toLowerCase().equals("@relation")) {
            this.relation = parts[1];
        } else if (parts[0].toLowerCase().equals("@delimiter")) {
            this.delimiter = parts[1];
        } else if (parts[0].toLowerCase().equals("@attribute")) {
            String key = parts[1];
            CSVSchemaColumn colValue = this.parseColumnSchemaFromAttribute(parts);
            this.columnSchemas.put(key, colValue);
        }
    }

    public void parseSchemaFile(String schemaPath) throws Exception {
        try (BufferedReader br = new BufferedReader(new FileReader(schemaPath));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!this.validateSchemaLine(line)) {
                    throw new Exception("Bad Schema for CSV Data: \n\t" + line);
                }
                this.addSchemaLine(line);
            }
        }
    }

    public int getTransformedVectorSize() {
        int colCount = 0;
        for (Map.Entry<String, CSVSchemaColumn> entry : this.columnSchemas.entrySet()) {
            if (entry.getValue().transform == CSVSchemaColumn.TransformType.SKIP) continue;
            ++colCount;
        }
        return colCount;
    }

    public void evaluateInputRecord(String csvRecordLine) throws Exception {
        String[] columns = csvRecordLine.split(this.delimiter);
        if (Strings.isNullOrEmpty((String)columns[0])) {
            log.info("Skipping blank line");
            return;
        }
        if (columns.length != this.columnSchemas.size()) {
            throw new Exception("Row column count does not match schema column count. (" + columns.length + " != " + this.columnSchemas.size() + ") ");
        }
        int colIndex = 0;
        for (Map.Entry<String, CSVSchemaColumn> entry : this.columnSchemas.entrySet()) {
            String colKey = entry.getKey();
            CSVSchemaColumn colSchemaEntry = entry.getValue();
            colSchemaEntry.evaluateColumnValue(columns[colIndex]);
            ++colIndex;
        }
    }

    public void computeDatasetStatistics() {
        this.hasComputedStats = true;
    }

    public void debugPringDatasetStatistics() {
        log.info("Print Schema --------");
        for (Map.Entry<String, CSVSchemaColumn> entry : this.columnSchemas.entrySet()) {
            String key = entry.getKey();
            CSVSchemaColumn value = entry.getValue();
            log.info("> " + value.name + ", " + (Object)((Object)value.columnType) + ", " + (Object)((Object)value.transform));
            if (value.transform == CSVSchemaColumn.TransformType.LABEL) {
                log.info("\t> Label > Class Balance Report ");
                for (Map.Entry<String, Pair<Integer, Integer>> label : value.recordLabels.entrySet()) {
                    log.info("\t\t " + label.getKey() + ": " + label.getValue().getFirst() + ", " + label.getValue().getSecond());
                }
                continue;
            }
            log.info("\t\tmin: {}", (Object)value.minValue);
            log.info("\t\tmax: {}", (Object)value.maxValue);
        }
        log.info("End Print Schema --------\n\n");
    }

    public void debugPrintColumns() {
        for (Map.Entry<String, CSVSchemaColumn> entry : this.columnSchemas.entrySet()) {
            String key = entry.getKey();
            CSVSchemaColumn value = entry.getValue();
            log.debug("> {} , {} , {}", new Object[]{value.name, value.columnType, value.transform});
        }
    }
}

