/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.cli.csv.schema;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.math3.util.Pair;

public class CSVSchemaColumn {
    public String name = "";
    public ColumnType columnType = null;
    public TransformType transform = null;
    public double minValue = Double.NaN;
    public double maxValue = Double.NaN;
    public long invalidDataEntries = 0L;
    public Map<String, Pair<Integer, Integer>> recordLabels = new LinkedHashMap<String, Pair<Integer, Integer>>();

    public CSVSchemaColumn(String colName, ColumnType colType, TransformType transformType) {
        this.name = colName;
        this.columnType = colType;
        this.transform = transformType;
    }

    public void evaluateColumnValue(String value) throws Exception {
        if (ColumnType.NUMERIC == this.columnType) {
            double tmpVal = Double.parseDouble(value);
            if (Double.isNaN(tmpVal)) {
                throw new Exception("The column was defined as Numeric yet could not be parsed as a Double");
            }
            if (Double.isNaN(this.minValue)) {
                this.minValue = tmpVal;
            } else if (tmpVal < this.minValue) {
                this.minValue = tmpVal;
            }
            if (Double.isNaN(this.maxValue)) {
                this.maxValue = tmpVal;
            } else if (tmpVal > this.maxValue) {
                this.maxValue = tmpVal;
            }
        } else if (ColumnType.NOMINAL == this.columnType) {
            String trimmedKey = value.trim();
            if (this.recordLabels.containsKey(trimmedKey)) {
                Integer countInt;
                Integer labelID = (Integer)this.recordLabels.get(trimmedKey).getFirst();
                Integer n = countInt = (Integer)this.recordLabels.get(trimmedKey).getSecond();
                Integer n2 = countInt = Integer.valueOf(countInt + 1);
                this.recordLabels.put(trimmedKey, (Pair<Integer, Integer>)new Pair((Object)labelID, (Object)countInt));
            } else {
                Integer labelID = this.recordLabels.size();
                this.recordLabels.put(trimmedKey, (Pair<Integer, Integer>)new Pair((Object)labelID, (Object)1));
            }
        }
    }

    public void computeStatistics() {
        if (ColumnType.NUMERIC == this.columnType) {
            // empty if block
        }
    }

    public void debugPrintColumns() {
        for (Map.Entry<String, Pair<Integer, Integer>> entry : this.recordLabels.entrySet()) {
            String key = entry.getKey();
            Pair<Integer, Integer> value = entry.getValue();
            System.out.println("> " + key + ", " + value);
        }
    }

    public Integer getLabelCount(String label) {
        if (this.recordLabels.containsKey(label)) {
            return (Integer)this.recordLabels.get(label).getSecond();
        }
        return 0;
    }

    public Integer getLabelID(String label) {
        if (this.recordLabels.containsKey(label)) {
            return (Integer)this.recordLabels.get(label).getFirst();
        }
        return null;
    }

    public double transformColumnValue(String inputColumnValue) {
        switch (this.transform) {
            case LABEL: {
                return this.label(inputColumnValue);
            }
            case BINARIZE: {
                return this.binarize(inputColumnValue);
            }
            case COPY: {
                return this.copy(inputColumnValue);
            }
            case NORMALIZE: {
                return this.normalize(inputColumnValue);
            }
            case SKIP: {
                return 0.0;
            }
        }
        return -1.0;
    }

    public double copy(String inputColumnValue) {
        double return_value = 0.0;
        if (this.columnType == ColumnType.NUMERIC) {
            return_value = Double.parseDouble(inputColumnValue);
        } else {
            String key = inputColumnValue.trim();
            return_value = this.getLabelID(key).intValue();
        }
        return return_value;
    }

    public double binarize(String inputColumnValue) {
        double range;
        double midpoint;
        double val = Double.parseDouble(inputColumnValue);
        if (val < (midpoint = (range = this.maxValue - this.minValue) / 2.0 + this.minValue)) {
            return 0.0;
        }
        return 1.0;
    }

    public double normalize(String inputColumnValue) {
        double return_value = 0.0;
        if (this.columnType == ColumnType.NUMERIC) {
            double val = Double.parseDouble(inputColumnValue);
            double range = this.maxValue - this.minValue;
            double normalizedOut = (val - this.minValue) / range;
            return_value = 0.0 == range ? 0.0 : normalizedOut;
        } else {
            String key = inputColumnValue.trim();
            double totalLabels = this.recordLabels.size();
            double labelIndex = (double)this.getLabelID(key).intValue() + 1.0;
            return_value = labelIndex / totalLabels;
        }
        return return_value;
    }

    public double label(String inputColumnValue) {
        double return_value = 0.0;
        if (this.columnType == ColumnType.NUMERIC) {
            return_value = Double.parseDouble(inputColumnValue);
        } else {
            Integer ID = this.getLabelID(inputColumnValue.trim());
            return_value = ID.intValue();
        }
        return return_value;
    }

    public static enum TransformType {
        COPY,
        SKIP,
        BINARIZE,
        NORMALIZE,
        LABEL;

    }

    public static enum ColumnType {
        NUMERIC,
        DATE,
        NOMINAL;

    }
}

