/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.cli.records.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.reader.impl.FileRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class LineRecordReader
extends FileRecordReader {
    private Collection<Collection<Writable>> records = new ArrayList<Collection<Writable>>();
    private BufferedReader textFileBufferedReader = null;
    private Scanner textFileScanner = null;
    private Configuration conf;
    private String currentLine = "";
    private String currentPath = "";

    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.initialize(new Configuration(), split);
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.currentFile = (File)this.iter.next();
        this.currentPath = this.currentFile.getAbsolutePath();
        this.textFileScanner = new Scanner(new FileInputStream(this.currentPath));
    }

    private void rotateScannerToNextFile() throws FileNotFoundException {
        this.currentFile = (File)this.iter.next();
        this.currentPath = this.currentFile.getAbsolutePath();
        this.textFileScanner = new Scanner(new FileInputStream(this.currentPath));
    }

    public Collection<Writable> next() {
        this.currentLine = null;
        boolean noMoreFiles = false;
        while (!this.textFileScanner.hasNextLine()) {
            try {
                this.rotateScannerToNextFile();
            }
            catch (FileNotFoundException e) {
                noMoreFiles = true;
            }
        }
        if (noMoreFiles) {
            this.iter = null;
            this.currentFile = null;
            throw new NoSuchElementException("No more elements found!");
        }
        this.currentLine = this.textFileScanner.nextLine();
        ArrayList<Writable> record = new ArrayList<Writable>();
        record.add((Writable)new Text(this.currentLine));
        record.add((Writable)new Text(this.getCurrentDirectoryLabelPath()));
        return record;
    }

    public boolean hasNext() {
        return null != this.textFileScanner && this.textFileScanner.hasNextLine() || this.iter != null && this.iter.hasNext();
    }

    public String getCurrentDirectoryLabelPath() {
        return this.currentFile.getParentFile().getName();
    }

    public void close() throws IOException {
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

