/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.cli.shuffle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.datavec.api.writable.Writable;

public class Shuffler {
    public List<Collection<Writable>> records;
    private Random rand = new Random();
    private ListIterator<Collection<Writable>> iterator = null;

    public Shuffler() {
        this.records = new ArrayList<Collection<Writable>>();
    }

    public void addRecord(Collection<Writable> record) {
        int slot = this.getRandomSlot();
        this.records.add(slot, record);
    }

    private int getRandomSlot() {
        int min = 0;
        return this.rand.nextInt(this.records.size() - min + 1) + min;
    }

    public boolean hasNext() {
        if (null == this.iterator) {
            this.iterator = this.records.listIterator();
        }
        return this.iterator.hasNext();
    }

    public Collection<Writable> next() {
        if (null == this.iterator) {
            this.iterator = this.records.listIterator();
        }
        return this.iterator.next();
    }
}

