/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.cli.subcommands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.datavec.api.conf.Configuration;
import org.datavec.api.exceptions.DataVecException;
import org.datavec.api.formats.input.InputFormat;
import org.datavec.api.formats.output.OutputFormat;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.FileSplit;
import org.datavec.api.split.InputSplit;
import org.datavec.cli.subcommands.SubCommand;
import org.datavec.cli.vectorization.VectorizationEngine;
import org.datavec.image.recordreader.ImageRecordReader;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vectorize
implements SubCommand {
    private static final Logger log = LoggerFactory.getLogger(Vectorize.class);
    public static final String OUTPUT_FILENAME_KEY = "datavec.output.directory";
    public static final String INPUT_FORMAT = "datavec.input.format";
    public static final String DEFAULT_INPUT_FORMAT_CLASSNAME = "org.datavec.api.formats.input.impl.LineInputFormat";
    public static final String OUTPUT_FORMAT = "datavec.output.format";
    public static final String DEFAULT_OUTPUT_FORMAT_CLASSNAME = "org.datavec.api.formats.output.impl.SVMLightOutputFormat";
    public static final String VECTORIZATION_ENGINE = "datavec.input.vectorization.engine";
    public static final String DEFAULT_VECTORIZATION_ENGINE_CLASSNAME = "org.datavec.cli.csv.vectorization.CSVVectorizationEngine";
    public static final String NORMALIZE_DATA_FLAG = "datavec.input.vectorization.normalize";
    public static final String SHUFFLE_DATA_FLAG = "datavec.output.shuffle";
    public static final String PRINT_STATS_FLAG = "datavec.input.statistics.debug.print";
    protected String[] args;
    public boolean validCommandLineParameters = true;
    @Option(name="-conf", usage="Sets a configuration file to drive the vectorization process")
    public String configurationFile = "";
    public Properties configProps = null;
    public String outputVectorFilename = "";
    public boolean normalizeData = true;

    public Vectorize() {
    }

    public void loadConfigFile() throws IOException {
        SimpleDateFormat dateFormat;
        String normalizeValue;
        this.configProps = new Properties();
        try (FileInputStream in = new FileInputStream(this.configurationFile);){
            this.configProps.load(in);
        }
        if (null != this.configProps.get(NORMALIZE_DATA_FLAG) && "false".equals(normalizeValue = (String)this.configProps.get(NORMALIZE_DATA_FLAG))) {
            this.normalizeData = false;
        }
        if (null == this.configProps.get(OUTPUT_FILENAME_KEY)) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            this.outputVectorFilename = "/tmp/datavec_vectors_" + dateFormat.format(new Date()) + ".txt";
        } else {
            this.outputVectorFilename = (String)this.configProps.get(OUTPUT_FILENAME_KEY);
            if (!new File(this.outputVectorFilename).exists()) {
                File yourFile = new File(this.outputVectorFilename);
                File parent = yourFile.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IllegalStateException("Couldn't create dir: " + parent);
                }
                if (!yourFile.exists()) {
                    yourFile.createNewFile();
                }
            } else if (new File(this.outputVectorFilename).isDirectory()) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
                this.outputVectorFilename = this.outputVectorFilename + "/datavec_vectors_" + dateFormat.format(new Date()) + ".txt";
            } else {
                new File(this.outputVectorFilename).delete();
                System.out.println("File path already exists, deleting the old file before proceeding...");
            }
        }
    }

    public void debugLoadedConfProperties() {
        Properties props = this.configProps;
        Enumeration<?> e = props.propertyNames();
        System.out.println("\n--- Start DataVec Configuration ---");
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            System.out.println(key + " -- " + props.getProperty(key));
        }
        System.out.println("---End DataVec Configuration ---\n");
    }

    public static void printUsage() {
        System.out.println("DataVec: Vectorization Engine");
        System.out.println("");
        System.out.println("\tUsage:");
        System.out.println("\t\tdatavec vectorize -conf <conf_file>");
        System.out.println("");
        System.out.println("\tConfiguration File:");
        System.out.println("\t\tContains a list of property entries that describe the vectorization process");
        System.out.println("");
        System.out.println("\tExample:");
        System.out.println("\t\tdatavec vectorize -conf /tmp/iris_conf.txt ");
    }

    @Override
    public void execute() throws Exception {
        String print;
        if ("".equals(this.configurationFile)) {
            Vectorize.printUsage();
            return;
        }
        if (!this.validCommandLineParameters) {
            log.error("Vectorize function is not configured properly, stopping.");
            return;
        }
        this.loadConfigFile();
        if (null != this.configProps.get("datavec.conf.print") && "true".equals((print = (String)this.configProps.get("datavec.conf.print")).trim().toLowerCase())) {
            this.debugLoadedConfProperties();
        }
        String datasetInputPath = (String)this.configProps.get("datavec.input.directory");
        String inputDataType = (String)this.configProps.get("datavec.input.data.type");
        if (null == inputDataType) {
            throw new IllegalStateException("Can't operate without input.data.type being set in the configuration file.");
        }
        Configuration conf = new Configuration();
        conf.set("org.nd4j.outputpath", this.outputVectorFilename);
        conf.setBoolean(ImageRecordReader.APPEND_LABEL, true);
        File inputFile = new File(datasetInputPath);
        FileSplit split = new FileSplit(inputFile);
        InputFormat inputFormat = this.createInputFormat();
        RecordReader reader = inputFormat.createReader((InputSplit)split, conf);
        VectorizationEngine engine = this.createVectorizationEngine();
        engine.initialize((InputSplit)split, inputFormat, this.createOutputFormat(), reader, this.createOutputFormat().createWriter(conf), this.configProps, this.outputVectorFilename, conf);
        boolean vectorizationComplete = true;
        String failureString = "";
        try {
            engine.execute();
        }
        catch (DataVecException ce) {
            vectorizationComplete = false;
            failureString = ce.toString();
        }
        if (!vectorizationComplete) {
            System.out.println("Vectorization failed due to: \n" + failureString);
        } else {
            System.out.println("Output vectors written to: " + this.outputVectorFilename);
        }
    }

    public Vectorize(String[] args) {
        this.args = args;
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            this.validCommandLineParameters = false;
            parser.printUsage((OutputStream)System.err);
            log.error("Unable to parse args", (Throwable)e);
        }
    }

    public InputFormat createInputFormat() {
        String clazz = (String)this.configProps.get(INPUT_FORMAT);
        if (null == clazz) {
            clazz = DEFAULT_INPUT_FORMAT_CLASSNAME;
        }
        try {
            Class<?> inputFormatClazz = Class.forName(clazz);
            return (InputFormat)inputFormatClazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public OutputFormat createOutputFormat() {
        String clazz = (String)this.configProps.get(OUTPUT_FORMAT);
        if (null == clazz) {
            clazz = DEFAULT_OUTPUT_FORMAT_CLASSNAME;
        }
        try {
            Class<?> outputFormatClazz = Class.forName(clazz);
            return (OutputFormat)outputFormatClazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VectorizationEngine createVectorizationEngine() {
        String inputDataType;
        String clazz = DEFAULT_VECTORIZATION_ENGINE_CLASSNAME;
        switch (inputDataType = (String)this.configProps.get("datavec.input.data.type")) {
            case "csv": {
                clazz = "org.datavec.cli.vectorization.CSVVectorizationEngine";
                break;
            }
            case "text": {
                clazz = "org.datavec.cli.vectorization.TextVectorizationEngine";
                break;
            }
            case "audio": {
                clazz = "org.datavec.cli.vectorization.AudioVectorizationEngine";
                break;
            }
            case "image": {
                clazz = "org.datavec.cli.vectorization.ImageVectorizationEngine";
                break;
            }
            case "video": {
                clazz = "org.datavec.cli.vectorization.VideoVectorizationEngine";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid input Data Type" + inputDataType);
            }
        }
        try {
            Class<?> vecEngineClazz = Class.forName(clazz);
            return (VectorizationEngine)vecEngineClazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

