/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.cli.transforms.image;

import java.util.Collection;
import java.util.Iterator;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.Writable;
import org.datavec.cli.transforms.Transform;
import org.datavec.common.data.NDArrayWritable;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NormalizeTransform
implements Transform {
    public long totalRecords = 0L;
    public double minValue = Double.NaN;
    public double maxValue = Double.NaN;

    @Override
    public void transform(Collection<Writable> vector) {
        if (Double.NaN == this.minValue) {
            return;
        }
        Iterator<Writable> iter = vector.iterator();
        boolean isLabelEntry = false;
        if (!iter.hasNext()) {
            isLabelEntry = true;
        }
        while (iter.hasNext()) {
            Writable val = iter.next();
            if (val instanceof NDArrayWritable) {
                INDArray arr = ((NDArrayWritable)val).get();
                for (int i = 0; i < arr.length(); ++i) {
                    double range = this.maxValue - this.minValue;
                    double normalizedOut = (arr.getDouble(i) - this.minValue) / range;
                    if (0.0 == range) {
                        arr.putScalar(i, 0.0);
                        continue;
                    }
                    arr.putScalar(i, normalizedOut);
                }
                continue;
            }
            if (val instanceof DoubleWritable) {
                DoubleWritable dVal = (DoubleWritable)val;
                if (isLabelEntry) continue;
                double range = this.maxValue - this.minValue;
                double normalizedOut = (dVal.get() - this.minValue) / range;
                if (0.0 == range) {
                    dVal.set(0.0);
                    continue;
                }
                dVal.set(normalizedOut);
                continue;
            }
            FloatWritable valF = (FloatWritable)val;
            if (isLabelEntry) continue;
            float range = (float)(this.maxValue - this.minValue);
            float normalizedOut = (float)(((double)valF.get() - this.minValue) / (double)range);
            if (0.0 == (double)range) {
                valF.set(0.0f);
                continue;
            }
            valF.set(normalizedOut);
        }
    }

    @Override
    public void collectStatistics(Collection<Writable> vector) {
        for (Writable val : vector) {
            INDArray arr = val instanceof NDArrayWritable ? ((NDArrayWritable)val).get() : null;
            for (int i = 0; i < (arr != null ? arr.length() : 1); ++i) {
                double tmpVal;
                double d = tmpVal = arr != null ? arr.getDouble(i) : Double.valueOf(val.toString()).doubleValue();
                if (Double.isNaN(this.minValue)) {
                    this.minValue = tmpVal;
                } else if (tmpVal < this.minValue) {
                    this.minValue = tmpVal;
                }
                if (Double.isNaN(this.maxValue)) {
                    this.maxValue = tmpVal;
                    continue;
                }
                if (!(tmpVal > this.maxValue)) continue;
                this.maxValue = tmpVal;
            }
        }
    }

    @Override
    public void evaluateStatistics() {
    }
}

