/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.cli.vectorization;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.datavec.api.conf.Configuration;
import org.datavec.api.exceptions.DataVecException;
import org.datavec.api.records.writer.RecordWriter;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.datavec.cli.csv.schema.CSVInputSchema;
import org.datavec.cli.csv.schema.CSVSchemaColumn;
import org.datavec.cli.shuffle.Shuffler;
import org.datavec.cli.vectorization.VectorizationEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVVectorizationEngine
extends VectorizationEngine {
    private static final Logger log = LoggerFactory.getLogger(CSVVectorizationEngine.class);
    public static final String SKIP_HEADER_KEY = "datavec.input.header.skip";
    private CSVInputSchema inputSchema = null;
    private boolean skipHeader = false;

    private void loadInputSchemaFile() throws Exception {
        String schemaFilePath = (String)this.configProps.get("datavec.input.vector.schema");
        this.inputSchema = new CSVInputSchema();
        this.inputSchema.parseSchemaFile(schemaFilePath);
        if (null != this.configProps.get(SKIP_HEADER_KEY)) {
            String headerSkipString = (String)this.configProps.get(SKIP_HEADER_KEY);
            this.skipHeader = "true".equals(headerSkipString.trim().toLowerCase());
        }
    }

    @Override
    public void execute() throws DataVecException, IOException, InterruptedException {
        long recordsRead = 0L;
        long recordsWritten = 0L;
        try {
            this.loadInputSchemaFile();
        }
        catch (Exception e1) {
            throw new DataVecException(e1.toString());
        }
        while (this.reader.hasNext()) {
            Collection w = this.reader.next();
            if (this.skipHeader && recordsRead == 0L) {
                System.out.println("Skipping Header: " + w.toArray()[0].toString());
            } else {
                try {
                    this.inputSchema.evaluateInputRecord(w.toArray()[0].toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++recordsRead;
        }
        this.reader.close();
        this.inputSchema.computeDatasetStatistics();
        if (this.printStats) {
            this.inputSchema.debugPringDatasetStatistics();
        }
        this.reader = this.inputFormat.createReader(this.split);
        Configuration conf = new Configuration();
        conf.set("org.nd4j.outputpath", this.outputFilename);
        boolean skippedHeaderYet = false;
        if (this.shuffleOn) {
            Shuffler shuffle = new Shuffler();
            RecordWriter writer2 = this.outputFormat.createWriter(conf);
            while (this.reader.hasNext()) {
                if (this.skipHeader && !skippedHeaderYet) {
                    skippedHeaderYet = true;
                    Collection collection = this.reader.next();
                    continue;
                }
                Collection w = this.reader.next();
                String line = w.toArray()[0].toString();
                if (!Strings.isNullOrEmpty((String)line)) {
                    shuffle.addRecord(this.vectorizeToWritable("", line, this.inputSchema));
                }
                ++recordsWritten;
            }
            while (shuffle.hasNext()) {
                Collection<Writable> shuffledRecord = shuffle.next();
                writer2.write(shuffledRecord);
            }
            this.reader.close();
            writer2.close();
        } else {
            RecordWriter writer = this.outputFormat.createWriter(conf);
            while (this.reader.hasNext()) {
                if (this.skipHeader && !skippedHeaderYet) {
                    skippedHeaderYet = true;
                    Collection writer2 = this.reader.next();
                    continue;
                }
                Collection w = this.reader.next();
                String line = w.toArray()[0].toString();
                if (!Strings.isNullOrEmpty((String)line)) {
                    writer.write(this.vectorizeToWritable("", line, this.inputSchema));
                }
                ++recordsWritten;
            }
            this.reader.close();
            writer.close();
        }
        System.out.println("CSV Lines Read: " + recordsRead);
        System.out.println("Vector Records Written: " + recordsWritten);
    }

    public Collection<Writable> vectorize(String key, String value, CSVInputSchema schema) {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        String[] columns = value.split(schema.delimiter);
        if (columns[0].trim().equals("")) {
            return null;
        }
        int srcColIndex = 0;
        int dstColIndex = 0;
        double label = 0.0;
        for (Map.Entry<String, CSVSchemaColumn> entry : schema.getColumnSchemas().entrySet()) {
            String colKey = entry.getKey();
            CSVSchemaColumn colSchemaEntry = entry.getValue();
            switch (colSchemaEntry.transform) {
                case SKIP: {
                    break;
                }
                case LABEL: {
                    label = colSchemaEntry.transformColumnValue(columns[srcColIndex].trim());
                    break;
                }
                default: {
                    double convertedColumn = colSchemaEntry.transformColumnValue(columns[srcColIndex].trim());
                    ret.add((Writable)new DoubleWritable(convertedColumn));
                    ++dstColIndex;
                }
            }
            ++srcColIndex;
        }
        ret.add((Writable)new DoubleWritable(label));
        return ret;
    }

    public Collection<Writable> vectorizeToWritable(String key, String value, CSVInputSchema schema) {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        String[] columns = value.split(schema.delimiter);
        if (columns[0].trim().equals("")) {
            return null;
        }
        int srcColIndex = 0;
        int dstColIndex = 0;
        for (Map.Entry<String, CSVSchemaColumn> entry : schema.getColumnSchemas().entrySet()) {
            String colKey = entry.getKey();
            CSVSchemaColumn colSchemaEntry = entry.getValue();
            switch (colSchemaEntry.transform) {
                case SKIP: {
                    break;
                }
                default: {
                    double convertedColumn = colSchemaEntry.transformColumnValue(columns[srcColIndex].trim());
                    ret.add((Writable)new Text(convertedColumn + ""));
                    ++dstColIndex;
                }
            }
            ++srcColIndex;
        }
        return ret;
    }
}

