/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.cli.vectorization;

import java.io.IOException;
import java.util.Collection;
import org.datavec.api.writable.Writable;
import org.datavec.cli.shuffle.Shuffler;
import org.datavec.cli.transforms.image.NormalizeTransform;
import org.datavec.cli.vectorization.VectorizationEngine;

public class ImageVectorizationEngine
extends VectorizationEngine {
    @Override
    public void execute() throws IOException {
        Collection w;
        NormalizeTransform normalizer = new NormalizeTransform();
        while (this.reader.hasNext()) {
            w = this.reader.next();
            normalizer.collectStatistics(w);
        }
        this.reader.close();
        try {
            this.reader = this.inputFormat.createReader(this.split, this.conf);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.shuffleOn) {
            Shuffler shuffle = new Shuffler();
            while (this.reader.hasNext()) {
                Collection w2 = this.reader.next();
                if (this.normalizeData) {
                    normalizer.transform(w2);
                }
                shuffle.addRecord(w2);
            }
            while (shuffle.hasNext()) {
                Collection<Writable> shuffledRecord = shuffle.next();
                this.writer.write(shuffledRecord);
            }
        } else {
            while (this.reader.hasNext()) {
                w = this.reader.next();
                if (this.normalizeData) {
                    normalizer.transform(w);
                }
                this.writer.write(w);
            }
        }
        this.reader.close();
        this.writer.close();
    }
}

