/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.cli.vectorization;

import java.io.IOException;
import java.util.Collection;
import org.datavec.api.writable.Writable;
import org.datavec.cli.shuffle.Shuffler;
import org.datavec.cli.transforms.text.nlp.TfidfTextVectorizerTransform;
import org.datavec.cli.vectorization.VectorizationEngine;

public class TextVectorizationEngine
extends VectorizationEngine {
    @Override
    public void execute() throws IOException {
        Collection w;
        TfidfTextVectorizerTransform tfidfTransform = new TfidfTextVectorizerTransform();
        this.conf.setInt("org.nd4j.nlp.minwordfrequency", 1);
        tfidfTransform.initialize(this.conf);
        int recordsSeen = 0;
        while (this.reader.hasNext()) {
            w = this.reader.next();
            tfidfTransform.collectStatistics(w);
            ++recordsSeen;
        }
        if (this.printStats) {
            System.out.println("Total Records: " + recordsSeen);
            System.out.println("Total Labels: " + tfidfTransform.getNumberOfLabelsSeen());
            System.out.println("Vocabulary Size of Corpus: " + tfidfTransform.getVocabularySize());
            tfidfTransform.debugPrintVocabList();
        }
        this.reader.close();
        try {
            this.reader = this.inputFormat.createReader(this.split, this.conf);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.shuffleOn) {
            Shuffler shuffle = new Shuffler();
            while (this.reader.hasNext()) {
                Collection w2 = this.reader.next();
                tfidfTransform.transform(w2);
                shuffle.addRecord(w2);
            }
            while (shuffle.hasNext()) {
                Collection<Writable> shuffledRecord = shuffle.next();
                this.writer.write(shuffledRecord);
            }
            this.reader.close();
            this.writer.close();
        } else {
            while (this.reader.hasNext()) {
                w = this.reader.next();
                tfidfTransform.transform(w);
                this.writer.write(w);
            }
            this.reader.close();
            this.writer.close();
        }
    }
}

