/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.cli.vectorization;

import java.io.IOException;
import java.util.Properties;
import org.datavec.api.conf.Configuration;
import org.datavec.api.exceptions.DataVecException;
import org.datavec.api.formats.input.InputFormat;
import org.datavec.api.formats.output.OutputFormat;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.writer.RecordWriter;
import org.datavec.api.split.InputSplit;

public abstract class VectorizationEngine {
    protected InputFormat inputFormat = null;
    protected OutputFormat outputFormat = null;
    protected InputSplit split = null;
    protected RecordWriter writer = null;
    protected RecordReader reader = null;
    protected Properties configProps = null;
    protected String outputFilename = null;
    protected Configuration conf = null;
    protected boolean shuffleOn = false;
    protected boolean normalizeData = true;
    protected boolean printStats = false;

    public void initialize(InputSplit split, InputFormat inputFormat, OutputFormat outputFormat, RecordReader reader, RecordWriter writer, Properties configProps, String outputFilename, Configuration conf) {
        String printSchema;
        this.split = split;
        this.reader = reader;
        this.writer = writer;
        this.configProps = configProps;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.outputFilename = outputFilename;
        this.conf = conf;
        if (null != this.configProps.get("datavec.output.shuffle")) {
            String shuffleValue = (String)this.configProps.get("datavec.output.shuffle");
            if ("true".equals(shuffleValue)) {
                this.shuffleOn = true;
            }
            System.out.println("Shuffle was turned on for this dataset.");
        }
        if (null != this.configProps.get("datavec.input.vectorization.normalize")) {
            String normalizeValue = (String)this.configProps.get("datavec.input.vectorization.normalize");
            if ("false".equals(normalizeValue)) {
                this.normalizeData = false;
            }
            System.out.println("Normalization was turned off for this dataset.");
        }
        if (null != this.configProps.get("datavec.input.statistics.debug.print") && "true".equals((printSchema = (String)this.configProps.get("datavec.input.statistics.debug.print")).trim().toLowerCase())) {
            this.printStats = true;
        }
    }

    public abstract void execute() throws DataVecException, IOException, InterruptedException;

    public void addTransform() {
        throw new UnsupportedOperationException();
    }

    public void applyTransforms() {
        throw new UnsupportedOperationException();
    }
}

