/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScaleImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    private float dx;
    private float dy;
    private int srch;
    private int h;
    private int srcw;
    private int w;

    public ScaleImageTransform(float delta) {
        this(null, delta, delta);
    }

    public ScaleImageTransform(Random random, float delta) {
        this(random, delta, delta);
    }

    public ScaleImageTransform(@JsonProperty(value="dx") float dx, @JsonProperty(value="dy") float dy) {
        this(null, dx, dy);
    }

    public ScaleImageTransform(Random random, float dx, float dy) {
        super(random);
        this.dx = dx;
        this.dy = dy;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        this.srch = mat.rows();
        this.srcw = mat.cols();
        this.h = Math.round((float)mat.rows() + this.dy * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f));
        this.w = Math.round((float)mat.cols() + this.dx * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f));
        opencv_core.Mat result = new opencv_core.Mat();
        opencv_imgproc.resize((opencv_core.Mat)mat, (opencv_core.Mat)result, (opencv_core.Size)new opencv_core.Size(this.w, this.h));
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            transformed[i] = (float)this.w * coordinates[i] / (float)this.srcw;
            transformed[i + 1] = (float)this.h * coordinates[i + 1] / (float)this.srch;
        }
        return transformed;
    }

    public float getDx() {
        return this.dx;
    }

    public float getDy() {
        return this.dy;
    }

    public int getSrch() {
        return this.srch;
    }

    public int getH() {
        return this.h;
    }

    public int getSrcw() {
        return this.srcw;
    }

    public int getW() {
        return this.w;
    }

    public void setDx(float dx) {
        this.dx = dx;
    }

    public void setDy(float dy) {
        this.dy = dy;
    }

    public void setSrch(int srch) {
        this.srch = srch;
    }

    public void setH(int h) {
        this.h = h;
    }

    public void setSrcw(int srcw) {
        this.srcw = srcw;
    }

    public void setW(int w) {
        this.w = w;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScaleImageTransform)) {
            return false;
        }
        ScaleImageTransform other = (ScaleImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getDx(), other.getDx()) != 0) {
            return false;
        }
        if (Float.compare(this.getDy(), other.getDy()) != 0) {
            return false;
        }
        if (this.getSrch() != other.getSrch()) {
            return false;
        }
        if (this.getH() != other.getH()) {
            return false;
        }
        if (this.getSrcw() != other.getSrcw()) {
            return false;
        }
        return this.getW() == other.getW();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScaleImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getDx());
        result = result * 59 + Float.floatToIntBits(this.getDy());
        result = result * 59 + this.getSrch();
        result = result * 59 + this.getH();
        result = result * 59 + this.getSrcw();
        result = result * 59 + this.getW();
        return result;
    }

    @Override
    public String toString() {
        return "ScaleImageTransform(dx=" + this.getDx() + ", dy=" + this.getDy() + ", srch=" + this.getSrch() + ", h=" + this.getH() + ", srcw=" + this.getSrcw() + ", w=" + this.getW() + ")";
    }
}

