/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.opencv.opencv_core.Mat;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.datavec.image.transform.ImageTransform;
import org.datavec.image.transform.PipelineImageTransform;

public class MultiImageTransform
extends BaseImageTransform<Mat> {
    private PipelineImageTransform transform;

    public MultiImageTransform(ImageTransform ... transforms) {
        this((Random)null, transforms);
    }

    public MultiImageTransform(Random random, ImageTransform ... transforms) {
        super(random);
        this.transform = new PipelineImageTransform(transforms);
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        return random == null ? this.transform.transform(image) : this.transform.transform(image, random);
    }

    @Override
    public float[] query(float ... coordinates) {
        return this.transform.query(coordinates);
    }

    public PipelineImageTransform getTransform() {
        return this.transform;
    }

    public void setTransform(PipelineImageTransform transform) {
        this.transform = transform;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiImageTransform)) {
            return false;
        }
        MultiImageTransform other = (MultiImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PipelineImageTransform this$transform = this.getTransform();
        PipelineImageTransform other$transform = other.getTransform();
        return !(this$transform == null ? other$transform != null : !((Object)this$transform).equals(other$transform));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultiImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PipelineImageTransform $transform = this.getTransform();
        result = result * 59 + ($transform == null ? 43 : ((Object)$transform).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MultiImageTransform(transform=" + this.getTransform() + ")";
    }
}

