package org.datavec.dataframe.filtering;

import org.datavec.dataframe.api.Table;
import org.datavec.dataframe.api.TimeColumn;
import org.datavec.dataframe.columns.ColumnReference;
import org.datavec.dataframe.util.Selection;

import java.time.LocalTime;

/**
 */
public class TimeEqualTo extends ColumnFilter {

    LocalTime value;

    public TimeEqualTo(ColumnReference reference, LocalTime value) {
        super(reference);
        this.value = value;
    }

    public Selection apply(Table relation) {
        TimeColumn dateColumn = (TimeColumn) relation.column(columnReference.getColumnName());
        return dateColumn.isEqualTo(value);
    }
}
