/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.hadoop.records.reader.mapfile;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;
import org.datavec.hadoop.records.reader.mapfile.IndexToKey;
import org.datavec.hadoop.records.reader.mapfile.index.LongIndexToKey;
import org.datavec.hadoop.records.reader.mapfile.record.RecordWritable;
import org.nd4j.linalg.primitives.Pair;

public class MapFileReader<V>
implements Closeable {
    private MapFile.Reader[] readers;
    private IndexToKey indexToKey;
    private Class<? extends Writable> recordClass;
    private List<Pair<Long, Long>> recordIndexesEachReader;
    private Long numRecords;

    public MapFileReader(String path) throws Exception {
        this(path, (IndexToKey)new LongIndexToKey(), RecordWritable.class);
    }

    public MapFileReader(String path, IndexToKey indexToKey, Class<? extends Writable> recordClass) throws IOException {
        this(Collections.singletonList(path), indexToKey, recordClass);
    }

    public MapFileReader(List<String> paths, IndexToKey indexToKey, Class<? extends Writable> recordClass) throws IOException {
        this.indexToKey = indexToKey;
        this.recordClass = recordClass;
        this.readers = new MapFile.Reader[paths.size()];
        SequenceFile.Reader.Option[] opts = new SequenceFile.Reader.Option[]{};
        Configuration config = new Configuration();
        for (int i = 0; i < paths.size(); ++i) {
            this.readers[i] = new MapFile.Reader(new Path(paths.get(i)), config, opts);
            if (this.readers[i].getValueClass() == recordClass) continue;
            throw new UnsupportedOperationException("MapFile record class: " + this.readers[i].getValueClass() + ", but got class " + recordClass + ", path = " + paths.get(i));
        }
        this.recordIndexesEachReader = indexToKey.initialize(this.readers, recordClass);
    }

    public long numRecords() {
        if (this.numRecords == null) {
            try {
                this.numRecords = this.indexToKey.getNumRecords();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.numRecords;
    }

    public V getRecord(long index) throws IOException {
        int readerIdx = -1;
        for (int i = 0; i < this.recordIndexesEachReader.size(); ++i) {
            Pair<Long, Long> p = this.recordIndexesEachReader.get(i);
            if (index < (Long)p.getFirst() || index > (Long)p.getSecond()) continue;
            readerIdx = i;
            break;
        }
        if (readerIdx == -1) {
            throw new IllegalStateException("Index not found in any reader: " + index);
        }
        WritableComparable key = this.indexToKey.getKeyForIndex(index);
        Writable value = (Writable)ReflectionUtils.newInstance(this.recordClass, null);
        Writable v = this.readers[readerIdx].get(key, value);
        return (V)v;
    }

    @Override
    public void close() throws IOException {
        for (MapFile.Reader r : this.readers) {
            r.close();
        }
    }
}

