/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.functions.pairdata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.hadoop.io.Writable;

public class BytesPairWritable
implements Serializable,
Writable {
    private byte[] first;
    private byte[] second;
    private String uriFirst;
    private String uriSecond;

    public BytesPairWritable() {
    }

    public BytesPairWritable(byte[] first, byte[] second, String uriFirst, String uriSecond) {
        this.first = first;
        this.second = second;
        this.uriFirst = uriFirst;
        this.uriSecond = uriSecond;
    }

    public void write(DataOutput dataOutput) throws IOException {
        int length1 = this.first != null ? this.first.length : 0;
        int length2 = this.second != null ? this.second.length : 0;
        byte[] s1Bytes = this.uriFirst != null ? this.uriFirst.getBytes(Charset.forName("UTF-8")) : null;
        byte[] s2Bytes = this.uriSecond != null ? this.uriSecond.getBytes(Charset.forName("UTF-8")) : null;
        int s1Len = s1Bytes != null ? s1Bytes.length : 0;
        int s2Len = s2Bytes != null ? s2Bytes.length : 0;
        dataOutput.writeInt(length1);
        dataOutput.writeInt(length2);
        dataOutput.writeInt(s1Len);
        dataOutput.writeInt(s2Len);
        if (this.first != null) {
            dataOutput.write(this.first);
        }
        if (this.second != null) {
            dataOutput.write(this.second);
        }
        if (s1Bytes != null) {
            dataOutput.write(s1Bytes);
        }
        if (s2Bytes != null) {
            dataOutput.write(s2Bytes);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        int length1 = dataInput.readInt();
        int length2 = dataInput.readInt();
        int s1Len = dataInput.readInt();
        int s2Len = dataInput.readInt();
        if (length1 > 0) {
            this.first = new byte[length1];
            dataInput.readFully(this.first);
        }
        if (length2 > 0) {
            this.second = new byte[length2];
            dataInput.readFully(this.second);
        }
        if (s1Len > 0) {
            byte[] s1Bytes = new byte[s1Len];
            dataInput.readFully(s1Bytes);
            this.uriFirst = new String(s1Bytes, Charset.forName("UTF-8"));
        }
        if (s2Len > 0) {
            byte[] s2Bytes = new byte[s2Len];
            dataInput.readFully(s2Bytes);
            this.uriSecond = new String(s2Bytes, Charset.forName("UTF-8"));
        }
    }

    public byte[] getFirst() {
        return this.first;
    }

    public byte[] getSecond() {
        return this.second;
    }

    public String getUriFirst() {
        return this.uriFirst;
    }

    public String getUriSecond() {
        return this.uriSecond;
    }

    public void setFirst(byte[] first) {
        this.first = first;
    }

    public void setSecond(byte[] second) {
        this.second = second;
    }

    public void setUriFirst(String uriFirst) {
        this.uriFirst = uriFirst;
    }

    public void setUriSecond(String uriSecond) {
        this.uriSecond = uriSecond;
    }
}

