/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.analysis.columns;

import java.beans.ConstructorProperties;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.analysis.AnalysisCounter;

public class DoubleAnalysisCounter
implements AnalysisCounter<DoubleAnalysisCounter> {
    private long countZero;
    private long countPositive;
    private long countNegative;
    private long countMinValue;
    private double minValueSeen = Double.MAX_VALUE;
    private long countMaxValue;
    private double maxValueSeen = -4.9E-324;
    private long countNaN;
    private double sum;
    private long countTotal;

    public DoubleAnalysisCounter() {
    }

    @Override
    public DoubleAnalysisCounter add(Writable writable) {
        double value = writable.toDouble();
        if (value == 0.0) {
            ++this.countZero;
        } else if (value < 0.0) {
            ++this.countNegative;
        } else if (value > 0.0) {
            ++this.countPositive;
        } else if (Double.isNaN(value)) {
            ++this.countNaN;
        }
        if (value == this.minValueSeen) {
            ++this.countMinValue;
        } else if (value < this.minValueSeen) {
            this.minValueSeen = value;
            this.countMinValue = 1L;
        }
        if (value == this.maxValueSeen) {
            ++this.countMaxValue;
        } else if (value > this.maxValueSeen) {
            this.maxValueSeen = value;
            this.countMaxValue = 1L;
        }
        this.sum += value;
        ++this.countTotal;
        return this;
    }

    @Override
    public DoubleAnalysisCounter merge(DoubleAnalysisCounter other) {
        if (this.minValueSeen == other.minValueSeen) {
            this.countMinValue += other.countMinValue;
        } else if (this.minValueSeen > other.minValueSeen) {
            this.minValueSeen = other.minValueSeen;
            this.countMinValue = other.countMinValue;
        }
        if (this.maxValueSeen == other.maxValueSeen) {
            this.countMaxValue += other.countMaxValue;
        } else if (this.maxValueSeen < other.maxValueSeen) {
            this.maxValueSeen = other.maxValueSeen;
            this.countMaxValue = other.countMaxValue;
        }
        this.countZero += other.countZero;
        this.countPositive += other.countPositive;
        this.countNegative += other.countNegative;
        this.sum += other.sum;
        this.countNaN += other.countNaN;
        this.countTotal += other.countTotal;
        return this;
    }

    @ConstructorProperties(value={"countZero", "countPositive", "countNegative", "countMinValue", "minValueSeen", "countMaxValue", "maxValueSeen", "countNaN", "sum", "countTotal"})
    public DoubleAnalysisCounter(long countZero, long countPositive, long countNegative, long countMinValue, double minValueSeen, long countMaxValue, double maxValueSeen, long countNaN, double sum, long countTotal) {
        this.countZero = countZero;
        this.countPositive = countPositive;
        this.countNegative = countNegative;
        this.countMinValue = countMinValue;
        this.minValueSeen = minValueSeen;
        this.countMaxValue = countMaxValue;
        this.maxValueSeen = maxValueSeen;
        this.countNaN = countNaN;
        this.sum = sum;
        this.countTotal = countTotal;
    }

    public long getCountZero() {
        return this.countZero;
    }

    public long getCountPositive() {
        return this.countPositive;
    }

    public long getCountNegative() {
        return this.countNegative;
    }

    public long getCountMinValue() {
        return this.countMinValue;
    }

    public double getMinValueSeen() {
        return this.minValueSeen;
    }

    public long getCountMaxValue() {
        return this.countMaxValue;
    }

    public double getMaxValueSeen() {
        return this.maxValueSeen;
    }

    public long getCountNaN() {
        return this.countNaN;
    }

    public double getSum() {
        return this.sum;
    }

    public long getCountTotal() {
        return this.countTotal;
    }

    public void setCountZero(long countZero) {
        this.countZero = countZero;
    }

    public void setCountPositive(long countPositive) {
        this.countPositive = countPositive;
    }

    public void setCountNegative(long countNegative) {
        this.countNegative = countNegative;
    }

    public void setCountMinValue(long countMinValue) {
        this.countMinValue = countMinValue;
    }

    public void setMinValueSeen(double minValueSeen) {
        this.minValueSeen = minValueSeen;
    }

    public void setCountMaxValue(long countMaxValue) {
        this.countMaxValue = countMaxValue;
    }

    public void setMaxValueSeen(double maxValueSeen) {
        this.maxValueSeen = maxValueSeen;
    }

    public void setCountNaN(long countNaN) {
        this.countNaN = countNaN;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }

    public void setCountTotal(long countTotal) {
        this.countTotal = countTotal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleAnalysisCounter)) {
            return false;
        }
        DoubleAnalysisCounter other = (DoubleAnalysisCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCountZero() != other.getCountZero()) {
            return false;
        }
        if (this.getCountPositive() != other.getCountPositive()) {
            return false;
        }
        if (this.getCountNegative() != other.getCountNegative()) {
            return false;
        }
        if (this.getCountMinValue() != other.getCountMinValue()) {
            return false;
        }
        if (Double.compare(this.getMinValueSeen(), other.getMinValueSeen()) != 0) {
            return false;
        }
        if (this.getCountMaxValue() != other.getCountMaxValue()) {
            return false;
        }
        if (Double.compare(this.getMaxValueSeen(), other.getMaxValueSeen()) != 0) {
            return false;
        }
        if (this.getCountNaN() != other.getCountNaN()) {
            return false;
        }
        if (Double.compare(this.getSum(), other.getSum()) != 0) {
            return false;
        }
        return this.getCountTotal() == other.getCountTotal();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DoubleAnalysisCounter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $countZero = this.getCountZero();
        result = result * 59 + (int)($countZero >>> 32 ^ $countZero);
        long $countPositive = this.getCountPositive();
        result = result * 59 + (int)($countPositive >>> 32 ^ $countPositive);
        long $countNegative = this.getCountNegative();
        result = result * 59 + (int)($countNegative >>> 32 ^ $countNegative);
        long $countMinValue = this.getCountMinValue();
        result = result * 59 + (int)($countMinValue >>> 32 ^ $countMinValue);
        long $minValueSeen = Double.doubleToLongBits(this.getMinValueSeen());
        result = result * 59 + (int)($minValueSeen >>> 32 ^ $minValueSeen);
        long $countMaxValue = this.getCountMaxValue();
        result = result * 59 + (int)($countMaxValue >>> 32 ^ $countMaxValue);
        long $maxValueSeen = Double.doubleToLongBits(this.getMaxValueSeen());
        result = result * 59 + (int)($maxValueSeen >>> 32 ^ $maxValueSeen);
        long $countNaN = this.getCountNaN();
        result = result * 59 + (int)($countNaN >>> 32 ^ $countNaN);
        long $sum = Double.doubleToLongBits(this.getSum());
        result = result * 59 + (int)($sum >>> 32 ^ $sum);
        long $countTotal = this.getCountTotal();
        result = result * 59 + (int)($countTotal >>> 32 ^ $countTotal);
        return result;
    }

    public String toString() {
        return "DoubleAnalysisCounter(countZero=" + this.getCountZero() + ", countPositive=" + this.getCountPositive() + ", countNegative=" + this.getCountNegative() + ", countMinValue=" + this.getCountMinValue() + ", minValueSeen=" + this.getMinValueSeen() + ", countMaxValue=" + this.getCountMaxValue() + ", maxValueSeen=" + this.getMaxValueSeen() + ", countNaN=" + this.getCountNaN() + ", sum=" + this.getSum() + ", countTotal=" + this.getCountTotal() + ")";
    }
}

