/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.analysis.seqlength;

import java.beans.ConstructorProperties;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.analysis.AnalysisCounter;

public class SequenceLengthAnalysisCounter
implements AnalysisCounter<SequenceLengthAnalysisCounter> {
    private long countZeroLength;
    private long countOneLength;
    private long countMinLength;
    private int minLengthSeen = Integer.MAX_VALUE;
    private long countMaxLength;
    private int maxLengthSeen = Integer.MIN_VALUE;
    private long countTotal;
    private double mean;

    public SequenceLengthAnalysisCounter() {
    }

    @Override
    public SequenceLengthAnalysisCounter add(Writable writable) {
        return this;
    }

    @Override
    public SequenceLengthAnalysisCounter merge(SequenceLengthAnalysisCounter other) {
        long newCountMaxValue;
        int newMaxLengthSeen;
        long newCountMinValue;
        int newMinLengthSeen;
        int otherMin = other.getMinLengthSeen();
        if (this.minLengthSeen == otherMin) {
            newMinLengthSeen = this.minLengthSeen;
            newCountMinValue = this.countMinLength + other.countMinLength;
        } else if (this.minLengthSeen > otherMin) {
            newMinLengthSeen = otherMin;
            newCountMinValue = other.countMinLength;
        } else {
            newMinLengthSeen = this.minLengthSeen;
            newCountMinValue = this.countMinLength;
        }
        int otherMax = other.getMaxLengthSeen();
        if (this.maxLengthSeen == otherMax) {
            newMaxLengthSeen = this.maxLengthSeen;
            newCountMaxValue = this.countMaxLength + other.countMaxLength;
        } else if (this.maxLengthSeen < otherMax) {
            newMaxLengthSeen = otherMax;
            newCountMaxValue = other.countMaxLength;
        } else {
            newMaxLengthSeen = this.maxLengthSeen;
            newCountMaxValue = this.countMaxLength;
        }
        long newCountTotal = this.countTotal + other.countTotal;
        double sum = (double)this.countTotal * this.mean + (double)other.countTotal * other.mean;
        double newMean = sum / (double)newCountTotal;
        return new SequenceLengthAnalysisCounter(this.countZeroLength + other.countZeroLength, this.countOneLength + other.countOneLength, newCountMinValue, newMinLengthSeen, newCountMaxValue, newMaxLengthSeen, newCountTotal, newMean);
    }

    @ConstructorProperties(value={"countZeroLength", "countOneLength", "countMinLength", "minLengthSeen", "countMaxLength", "maxLengthSeen", "countTotal", "mean"})
    public SequenceLengthAnalysisCounter(long countZeroLength, long countOneLength, long countMinLength, int minLengthSeen, long countMaxLength, int maxLengthSeen, long countTotal, double mean) {
        this.countZeroLength = countZeroLength;
        this.countOneLength = countOneLength;
        this.countMinLength = countMinLength;
        this.minLengthSeen = minLengthSeen;
        this.countMaxLength = countMaxLength;
        this.maxLengthSeen = maxLengthSeen;
        this.countTotal = countTotal;
        this.mean = mean;
    }

    public long getCountZeroLength() {
        return this.countZeroLength;
    }

    public long getCountOneLength() {
        return this.countOneLength;
    }

    public long getCountMinLength() {
        return this.countMinLength;
    }

    public int getMinLengthSeen() {
        return this.minLengthSeen;
    }

    public long getCountMaxLength() {
        return this.countMaxLength;
    }

    public int getMaxLengthSeen() {
        return this.maxLengthSeen;
    }

    public long getCountTotal() {
        return this.countTotal;
    }

    public double getMean() {
        return this.mean;
    }

    public void setCountZeroLength(long countZeroLength) {
        this.countZeroLength = countZeroLength;
    }

    public void setCountOneLength(long countOneLength) {
        this.countOneLength = countOneLength;
    }

    public void setCountMinLength(long countMinLength) {
        this.countMinLength = countMinLength;
    }

    public void setMinLengthSeen(int minLengthSeen) {
        this.minLengthSeen = minLengthSeen;
    }

    public void setCountMaxLength(long countMaxLength) {
        this.countMaxLength = countMaxLength;
    }

    public void setMaxLengthSeen(int maxLengthSeen) {
        this.maxLengthSeen = maxLengthSeen;
    }

    public void setCountTotal(long countTotal) {
        this.countTotal = countTotal;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceLengthAnalysisCounter)) {
            return false;
        }
        SequenceLengthAnalysisCounter other = (SequenceLengthAnalysisCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCountZeroLength() != other.getCountZeroLength()) {
            return false;
        }
        if (this.getCountOneLength() != other.getCountOneLength()) {
            return false;
        }
        if (this.getCountMinLength() != other.getCountMinLength()) {
            return false;
        }
        if (this.getMinLengthSeen() != other.getMinLengthSeen()) {
            return false;
        }
        if (this.getCountMaxLength() != other.getCountMaxLength()) {
            return false;
        }
        if (this.getMaxLengthSeen() != other.getMaxLengthSeen()) {
            return false;
        }
        if (this.getCountTotal() != other.getCountTotal()) {
            return false;
        }
        return Double.compare(this.getMean(), other.getMean()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceLengthAnalysisCounter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $countZeroLength = this.getCountZeroLength();
        result = result * 59 + (int)($countZeroLength >>> 32 ^ $countZeroLength);
        long $countOneLength = this.getCountOneLength();
        result = result * 59 + (int)($countOneLength >>> 32 ^ $countOneLength);
        long $countMinLength = this.getCountMinLength();
        result = result * 59 + (int)($countMinLength >>> 32 ^ $countMinLength);
        result = result * 59 + this.getMinLengthSeen();
        long $countMaxLength = this.getCountMaxLength();
        result = result * 59 + (int)($countMaxLength >>> 32 ^ $countMaxLength);
        result = result * 59 + this.getMaxLengthSeen();
        long $countTotal = this.getCountTotal();
        result = result * 59 + (int)($countTotal >>> 32 ^ $countTotal);
        long $mean = Double.doubleToLongBits(this.getMean());
        result = result * 59 + (int)($mean >>> 32 ^ $mean);
        return result;
    }

    public String toString() {
        return "SequenceLengthAnalysisCounter(countZeroLength=" + this.getCountZeroLength() + ", countOneLength=" + this.getCountOneLength() + ", countMinLength=" + this.getCountMinLength() + ", minLengthSeen=" + this.getMinLengthSeen() + ", countMaxLength=" + this.getCountMaxLength() + ", maxLengthSeen=" + this.getMaxLengthSeen() + ", countTotal=" + this.getCountTotal() + ", mean=" + this.getMean() + ")";
    }
}

