/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.quality.string;

import java.beans.ConstructorProperties;
import org.apache.spark.api.java.function.Function2;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.quality.columns.StringQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Writable;

public class StringQualityAddFunction
implements Function2<StringQuality, Writable, StringQuality> {
    private final StringMetaData meta;

    public StringQuality call(StringQuality v1, Writable writable) throws Exception {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        long empty = v1.getCountEmptyString();
        long alphabetic = v1.getCountAlphabetic();
        long numerical = v1.getCountNumerical();
        long word = v1.getCountWordCharacter();
        long whitespaceOnly = v1.getCountWhitespace();
        String str = writable.toString();
        if (writable instanceof NullWritable) {
            ++countMissing;
        } else if (this.meta.isValid(writable)) {
            ++valid;
        } else {
            ++invalid;
        }
        if (str == null || str.isEmpty()) {
            ++empty;
        } else {
            if (str.matches("[a-zA-Z]")) {
                ++alphabetic;
            }
            if (str.matches("\\d+")) {
                ++numerical;
            }
            if (str.matches("\\w+")) {
                ++word;
            }
            if (str.matches("\\s+")) {
                ++whitespaceOnly;
            }
        }
        return new StringQuality(valid, invalid, countMissing, countTotal, empty, alphabetic, numerical, word, whitespaceOnly, 0L);
    }

    @ConstructorProperties(value={"meta"})
    public StringQualityAddFunction(StringMetaData meta) {
        this.meta = meta;
    }
}

