/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.analysis.columns;

import java.beans.ConstructorProperties;
import java.math.BigInteger;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.analysis.AnalysisCounter;

public class LongAnalysisCounter
implements AnalysisCounter<LongAnalysisCounter> {
    private long countZero;
    private long countPositive;
    private long countNegative;
    private long countMinValue;
    private long minValueSeen = Long.MAX_VALUE;
    private long countMaxValue;
    private long maxValueSeen = Long.MIN_VALUE;
    private BigInteger sum = BigInteger.ZERO;
    private long countTotal = 0L;
    private double mean;
    private double m2;

    public LongAnalysisCounter() {
    }

    @Override
    public LongAnalysisCounter add(Writable writable) {
        long value = writable.toLong();
        if (value == 0L) {
            ++this.countZero;
        } else if (value < 0L) {
            ++this.countNegative;
        } else {
            ++this.countPositive;
        }
        if (value == this.minValueSeen) {
            ++this.countMinValue;
        } else if (value < this.minValueSeen) {
            this.minValueSeen = value;
            this.countMinValue = 1L;
        }
        if (value == this.maxValueSeen) {
            ++this.countMaxValue;
        } else if (value > this.maxValueSeen) {
            this.maxValueSeen = value;
            this.countMaxValue = 1L;
        }
        this.sum = this.sum.add(BigInteger.valueOf(value));
        ++this.countTotal;
        double delta = (double)value - this.mean;
        this.mean += delta / (double)this.countTotal;
        this.m2 += delta * ((double)value - this.mean);
        return this;
    }

    @Override
    public LongAnalysisCounter merge(LongAnalysisCounter other) {
        if (this.minValueSeen == other.minValueSeen) {
            this.countMinValue += other.countMinValue;
        } else if (this.minValueSeen > other.minValueSeen) {
            this.minValueSeen = other.minValueSeen;
            this.countMinValue = other.countMinValue;
        }
        if (this.maxValueSeen == other.maxValueSeen) {
            this.countMaxValue += other.countMaxValue;
        } else if (this.maxValueSeen < other.maxValueSeen) {
            this.maxValueSeen = other.maxValueSeen;
            this.countMaxValue = other.countMaxValue;
        }
        if (this.countTotal == 0L) {
            this.mean = other.mean;
            this.m2 = other.m2;
        } else if (other.countTotal != 0L) {
            double delta = other.mean - this.mean;
            long tCount = this.countTotal + other.countTotal;
            this.mean = 10L * other.countTotal < this.countTotal ? (this.mean += delta * (double)other.countTotal / (double)tCount) : (10L * this.countTotal < other.countTotal ? other.mean - delta * (double)this.countTotal / (double)tCount : (this.mean * (double)this.countTotal + other.mean * (double)other.countTotal) / (double)tCount);
            this.m2 += other.m2 + delta * delta * (double)this.countTotal * (double)other.countTotal / (double)tCount;
        }
        this.countZero += other.countZero;
        this.countPositive += other.countPositive;
        this.countNegative += other.countNegative;
        this.sum = this.sum.add(other.sum);
        this.countTotal += other.countTotal;
        return this;
    }

    public double getSampleVariance() {
        if (this.countTotal <= 1L) {
            return Double.NaN;
        }
        return this.m2 / (double)(this.countTotal - 1L);
    }

    public double getSampleStdev() {
        return Math.sqrt(this.getSampleVariance());
    }

    @ConstructorProperties(value={"countZero", "countPositive", "countNegative", "countMinValue", "minValueSeen", "countMaxValue", "maxValueSeen", "sum", "countTotal", "mean", "m2"})
    public LongAnalysisCounter(long countZero, long countPositive, long countNegative, long countMinValue, long minValueSeen, long countMaxValue, long maxValueSeen, BigInteger sum, long countTotal, double mean, double m2) {
        this.countZero = countZero;
        this.countPositive = countPositive;
        this.countNegative = countNegative;
        this.countMinValue = countMinValue;
        this.minValueSeen = minValueSeen;
        this.countMaxValue = countMaxValue;
        this.maxValueSeen = maxValueSeen;
        this.sum = sum;
        this.countTotal = countTotal;
        this.mean = mean;
        this.m2 = m2;
    }

    public long getCountZero() {
        return this.countZero;
    }

    public long getCountPositive() {
        return this.countPositive;
    }

    public long getCountNegative() {
        return this.countNegative;
    }

    public long getCountMinValue() {
        return this.countMinValue;
    }

    public long getMinValueSeen() {
        return this.minValueSeen;
    }

    public long getCountMaxValue() {
        return this.countMaxValue;
    }

    public long getMaxValueSeen() {
        return this.maxValueSeen;
    }

    public BigInteger getSum() {
        return this.sum;
    }

    public long getCountTotal() {
        return this.countTotal;
    }

    public double getMean() {
        return this.mean;
    }

    public double getM2() {
        return this.m2;
    }

    public void setCountZero(long countZero) {
        this.countZero = countZero;
    }

    public void setCountPositive(long countPositive) {
        this.countPositive = countPositive;
    }

    public void setCountNegative(long countNegative) {
        this.countNegative = countNegative;
    }

    public void setCountMinValue(long countMinValue) {
        this.countMinValue = countMinValue;
    }

    public void setMinValueSeen(long minValueSeen) {
        this.minValueSeen = minValueSeen;
    }

    public void setCountMaxValue(long countMaxValue) {
        this.countMaxValue = countMaxValue;
    }

    public void setMaxValueSeen(long maxValueSeen) {
        this.maxValueSeen = maxValueSeen;
    }

    public void setSum(BigInteger sum) {
        this.sum = sum;
    }

    public void setCountTotal(long countTotal) {
        this.countTotal = countTotal;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setM2(double m2) {
        this.m2 = m2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongAnalysisCounter)) {
            return false;
        }
        LongAnalysisCounter other = (LongAnalysisCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCountZero() != other.getCountZero()) {
            return false;
        }
        if (this.getCountPositive() != other.getCountPositive()) {
            return false;
        }
        if (this.getCountNegative() != other.getCountNegative()) {
            return false;
        }
        if (this.getCountMinValue() != other.getCountMinValue()) {
            return false;
        }
        if (this.getMinValueSeen() != other.getMinValueSeen()) {
            return false;
        }
        if (this.getCountMaxValue() != other.getCountMaxValue()) {
            return false;
        }
        if (this.getMaxValueSeen() != other.getMaxValueSeen()) {
            return false;
        }
        BigInteger this$sum = this.getSum();
        BigInteger other$sum = other.getSum();
        if (this$sum == null ? other$sum != null : !((Object)this$sum).equals(other$sum)) {
            return false;
        }
        if (this.getCountTotal() != other.getCountTotal()) {
            return false;
        }
        if (Double.compare(this.getMean(), other.getMean()) != 0) {
            return false;
        }
        return Double.compare(this.getM2(), other.getM2()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LongAnalysisCounter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $countZero = this.getCountZero();
        result = result * 59 + (int)($countZero >>> 32 ^ $countZero);
        long $countPositive = this.getCountPositive();
        result = result * 59 + (int)($countPositive >>> 32 ^ $countPositive);
        long $countNegative = this.getCountNegative();
        result = result * 59 + (int)($countNegative >>> 32 ^ $countNegative);
        long $countMinValue = this.getCountMinValue();
        result = result * 59 + (int)($countMinValue >>> 32 ^ $countMinValue);
        long $minValueSeen = this.getMinValueSeen();
        result = result * 59 + (int)($minValueSeen >>> 32 ^ $minValueSeen);
        long $countMaxValue = this.getCountMaxValue();
        result = result * 59 + (int)($countMaxValue >>> 32 ^ $countMaxValue);
        long $maxValueSeen = this.getMaxValueSeen();
        result = result * 59 + (int)($maxValueSeen >>> 32 ^ $maxValueSeen);
        BigInteger $sum = this.getSum();
        result = result * 59 + ($sum == null ? 43 : ((Object)$sum).hashCode());
        long $countTotal = this.getCountTotal();
        result = result * 59 + (int)($countTotal >>> 32 ^ $countTotal);
        long $mean = Double.doubleToLongBits(this.getMean());
        result = result * 59 + (int)($mean >>> 32 ^ $mean);
        long $m2 = Double.doubleToLongBits(this.getM2());
        result = result * 59 + (int)($m2 >>> 32 ^ $m2);
        return result;
    }

    public String toString() {
        return "LongAnalysisCounter(countZero=" + this.getCountZero() + ", countPositive=" + this.getCountPositive() + ", countNegative=" + this.getCountNegative() + ", countMinValue=" + this.getCountMinValue() + ", minValueSeen=" + this.getMinValueSeen() + ", countMaxValue=" + this.getCountMaxValue() + ", maxValueSeen=" + this.getMaxValueSeen() + ", sum=" + this.getSum() + ", countTotal=" + this.getCountTotal() + ", mean=" + this.getMean() + ", m2=" + this.getM2() + ")";
    }
}

